/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import android.os.Handler;
import android.os.Looper;
import com.landicorp.android.eptapi.dock.DockEthernet;
import com.landicorp.android.eptapi.dock.DockPort;
import com.landicorp.android.eptapi.dock.Docker;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WifiDocker
extends Docker {
    private static final Logger logger = Logger.getLogger(WifiDocker.class);
    private static final int DOCKER_PAIR = 3;
    private static final int DOCKER_ADD_NETWORK = 4;
    private static final int DOCKER_CALL_PAIR_ACTIVITY = 5;
    private static final int DOCKER_SET_DMZ_ENABLED = 6;
    private static final int DOCKER_GET_DMZ_ENABLE_STATE = 7;
    private static Map<String, WifiDocker> DOCKERS = new ConcurrentHashMap<String, WifiDocker>();
    private static Map<String, DockPort> SERIAL_PORTS = new ConcurrentHashMap<String, DockPort>();
    private static Map<String, DockEthernet> ETHERNET_PORTS = new ConcurrentHashMap<String, DockEthernet>();

    public static WifiDocker getInstance() {
        return WifiDocker.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WifiDocker getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, WifiDocker> map = DOCKERS;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, "WIFI");
            if (DOCKERS.containsKey(key)) {
                return DOCKERS.get(key);
            }
            WifiDocker docker = new WifiDocker(packageName, "WIFI");
            DOCKERS.put(key, docker);
            return docker;
        }
    }

    private WifiDocker(String packageName, String dockerName) {
        super(packageName, dockerName);
    }

    public int addNetwork(String ssid) {
        Precondition.checkNotEmpty(ssid);
        return WifiDocker.nativeDockerAddNetwork(this.dockerName, ssid);
    }

    public int callPairActivity() {
        return WifiDocker.nativeDockerCallPairActivity(this.dockerName);
    }

    public synchronized void pair(OnPairResultListener listener) {
        Precondition.checkNotNull(listener);
        WifiDocker.nativeDockerPair(this.dockerName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockPort getDockPort(String portName) {
        Precondition.checkNotEmpty(portName);
        Map<String, DockPort> map = SERIAL_PORTS;
        synchronized (map) {
            String key = DeviceKeys.createKey(this.packageName, this.dockerName, portName);
            if (SERIAL_PORTS.containsKey(key)) {
                return SERIAL_PORTS.get(key);
            }
            DockPort serialPort = new DockPort(this.packageName, this.dockerName, portName);
            SERIAL_PORTS.put(key, serialPort);
            return serialPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockEthernet getDockEthernet(String portName) {
        Precondition.checkNotEmpty(portName);
        Map<String, DockEthernet> map = ETHERNET_PORTS;
        synchronized (map) {
            String key = DeviceKeys.createKey(this.packageName, this.dockerName, portName);
            if (ETHERNET_PORTS.containsKey(key)) {
                return ETHERNET_PORTS.get(key);
            }
            DockEthernet ethernetPort = new DockEthernet(this.packageName, this.dockerName, portName);
            ETHERNET_PORTS.put(key, ethernetPort);
            return ethernetPort;
        }
    }

    public int setDmzEnabled(boolean enabled) {
        return WifiDocker.nativeDockerSetDmzEnabled(this.dockerName, enabled ? 1 : 0);
    }

    public synchronized void getDmzEnableState(OnGetDmzStateListener listener) {
        Precondition.checkNotNull(listener);
        WifiDocker.nativeDockerGetDmzEnableState(this.dockerName, listener);
    }

    private static native int nativeDockerPair(String var0, OnPairResultListener var1);

    private static native int nativeDockerAddNetwork(String var0, String var1);

    private static native int nativeDockerCallPairActivity(String var0);

    private static native int nativeDockerSetDmzEnabled(String var0, int var1);

    private static native int nativeDockerGetDmzEnableState(String var0, OnGetDmzStateListener var1);

    static {
        System.loadLibrary("eptand_jni");
    }

    public static abstract class OnGetDmzStateListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode, final int state) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        OnGetDmzStateListener.this.onSuccess(state);
                    } else {
                        OnGetDmzStateListener.this.onError(retCode);
                    }
                }
            });
        }

        public abstract void onSuccess(int var1);

        public abstract void onError(int var1);
    }

    public static abstract class OnPairResultListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        OnPairResultListener.this.onPaired();
                    } else {
                        OnPairResultListener.this.onError(retCode);
                    }
                }
            });
        }

        public abstract void onPaired();

        public abstract void onError(int var1);
    }
}

