/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;

public abstract class Docker {
    private static final Logger logger = Logger.getLogger(Docker.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_UNSUPPORTED_VERSION = 37;
    public static final int ERROR_DEVICE_USED = 137;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_SERVER_NOT_EXIST = 165;
    public static final int ERROR_COMM_ERROR = 166;
    public static final int ERROR_STATUS_ERROR = 167;
    public static final int ERROR_RECONNECT_TIMEOUT = 168;
    public static final int STATUS_OTHER = 160;
    public static final int STATUS_CHANNEL_NOT_OPENED = 161;
    public static final int STATUS_UNPAIRED = 162;
    public static final int STATUS_PAIRED = 163;
    public static final int STATUS_CHANNEL_CONNECTED = 164;
    public static final String BASECOM0 = "BASECOM0";
    public static final String BASEUSBCOM1 = "BASEUSBCOM1";
    public static final String BASEUSBCOM2 = "BASEUSBCOM2";
    public static final String BASEUSBD = "BASEUSBD";
    public static final String ETH = "ETH";
    static final String DOCKER_WIFI = "WIFI";
    static final String DOCKER_BT = "BT";
    private static final int DOCKER_GET_ALL_DOCKER_INFOS = 1;
    private static final int DOCKER_GET_DOCKER_STATUS = 2;
    private static final int DOCKER_VSP_OFFSET = 256;
    static final int DOCKER_VSP_OPEN = 256;
    static final int DOCKER_VSP_CLOSE = 257;
    static final int DOCKER_VSP_WRITE = 258;
    static final int DOCKER_VSP_READ = 259;
    static final int DOCKER_VSP_IS_BUFFER_EMPTY = 260;
    static final int DOCKER_VSP_CLEAR_BUFFER = 261;
    static final int DOCKER_VSP_UPDATE_CONFIG = 262;
    private static final int DOCKER_ETH_OFFSET = 512;
    static final int DOCKER_ETH_OPEN = 512;
    static final int DOCKER_ETH_CLOSE = 513;
    static final int DOCKER_ETH_SET_NETWORK_INFO = 516;
    static final int DOCKER_ETH_GET_NETWORK_INFO = 517;
    static final int DOCKER_ETH_GET_CONFIG = 518;
    static final int DOCKER_ETH_SET_CONFIG = 519;
    static final int DOCKER_ETH_APPLY_CONFIG = 520;
    protected String dockerName;
    protected String packageName;

    Docker(String packageName, String dockerName) {
        this.packageName = packageName;
        this.dockerName = dockerName;
    }

    public int getDockStatus(IntegerBuffer status) {
        Precondition.checkNotNull(status);
        return Docker.nativeDockerGetStatus(this.dockerName, status);
    }

    private static native int nativeDockerGetStatus(String var0, IntegerBuffer var1);

    static {
        System.loadLibrary("eptand_jni");
    }
}

