/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import android.os.Handler;
import android.os.Looper;
import com.landicorp.android.eptapi.dock.EthernetInfo;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DockEthernet {
    static final Logger logger = Logger.getLogger(DockEthernet.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_UNSUPPORTED_FUNC = 37;
    public static final int ERROR_DEVICE_USED = 137;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_SERVER_NOT_EXIST = 165;
    public static final int ERROR_STATUS_ERROR = 167;
    public static final int ERROR_COMM = 193;
    public static final int ERROR_RECONNECT_TIMEOUT = 194;
    public static final int ERROR_DRIVER_UNSUPPORTED = 254;
    public static final int ERROR_MC_UNSUPPORTED = 65535;
    public static final String CONFIG_WAN0_MODE = "WAN0_MODE";
    public static final String CONFIG_WAN0_IP = "WAN0_IP";
    public static final String CONFIG_WAN0_GATEWAY = "WAN0_GATEWAY";
    public static final String CONFIG_WAN0_NETMASK = "WAN0_NETMASK";
    public static final String CONFIG_WAN0_DNS1 = "WAN0_DNS1";
    public static final String CONFIG_WAN0_DNS2 = "WAN0_DNS2";
    public static final String CONFIG_WAN0_DNS3 = "WAN0_DNS3";
    public static final String CONFIG_WAN0_MAC = "WAN0_MAC";
    public static final String CONFIG_WAN0_INNERIP = "INNER_IP";
    private String packageName;
    private int devHandle;
    private String dockerName;
    private String portName;
    private boolean isOpen;

    DockEthernet(String packageName, String dockerName, String portName) {
        this.packageName = packageName;
        this.dockerName = dockerName;
        this.portName = portName;
    }

    public synchronized int open() {
        if (this.isOpen) {
            return 0;
        }
        int ret = this.nativeEthOpen(this.dockerName, this.portName);
        this.isOpen = ret == 0;
        return ret;
    }

    public synchronized int close() {
        if (!this.isOpen) {
            return 0;
        }
        int ret = this.nativeEthClose();
        this.isOpen = ret != 0;
        return ret;
    }

    public synchronized void setEthernetInfo(EthernetInfo info, SetEthernetInfoListener listener) {
        Precondition.checkNotNull(info);
        Precondition.checkNotNull(listener);
        if (!this.isOpen) {
            listener.onError(1);
            return;
        }
        this.nativeEthSetNetworkInfo(info.toBinary(), listener);
    }

    public synchronized void getEthernetInfo(GetEthernetInfoListener listener) {
        Precondition.checkNotNull(listener);
        if (!this.isOpen) {
            listener.onError(1);
            return;
        }
        this.nativeEthGetNetworkInfo(listener);
    }

    public synchronized int setConfig(String key, String value) {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(value);
        if (!this.isOpen) {
            return 1;
        }
        return this.nativeEthSetConfig(key, value);
    }

    public synchronized int getConfig(Query query, GetEthernetConfigListener listener) {
        Precondition.checkNotNull(query);
        Precondition.checkNotNull(listener);
        if (!this.isOpen) {
            return 1;
        }
        return this.nativeEthGetConfig(query.toString(), listener);
    }

    public synchronized int applyConfig(ApplyEthernetConfigListener listener) {
        Precondition.checkNotNull(listener);
        if (!this.isOpen) {
            return 1;
        }
        return this.nativeEthApplyConfig(listener);
    }

    private native int nativeEthOpen(String var1, String var2);

    private native int nativeEthClose();

    private native int nativeEthSetNetworkInfo(byte[] var1, SetEthernetInfoListener var2);

    private native int nativeEthGetNetworkInfo(GetEthernetInfoListener var1);

    private native int nativeEthSetConfig(String var1, String var2);

    private native int nativeEthGetConfig(String var1, GetEthernetConfigListener var2);

    private native int nativeEthApplyConfig(ApplyEthernetConfigListener var1);

    static {
        System.loadLibrary("eptand_jni");
    }

    public static abstract class GetEthernetConfigListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode, byte[] configData) {
            final HashMap<String, String> configs = new HashMap<String, String>();
            if (retCode == 0 && configData != null) {
                this.parseConfigs(configData, configs);
            }
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        GetEthernetConfigListener.this.onSuccess(configs);
                    } else {
                        GetEthernetConfigListener.this.onError(retCode);
                    }
                }
            });
        }

        private void parseConfigs(byte[] data, Map<String, String> configs) {
            int offset = 0;
            if (data == null || configs == null) {
                return;
            }
            if (data.length >= 4) {
                int valLen;
                int N = BytesUtil.bcd2Int(Arrays.copyOfRange(data, 0, 4));
                offset += 4;
                for (int i = 0; i < N && offset < data.length; offset += valLen, ++i) {
                    int keyLen = BytesUtil.bcd2Int(Arrays.copyOfRange(data, offset, offset + 2));
                    byte[] key = Arrays.copyOfRange(data, offset += 2, offset + keyLen);
                    valLen = BytesUtil.bcd2Int(Arrays.copyOfRange(data, offset += keyLen, offset + 2));
                    byte[] value = Arrays.copyOfRange(data, offset += 2, offset + valLen);
                    configs.put(BytesUtil.fromBytes(key), BytesUtil.fromBytes(value));
                }
            }
        }

        public abstract void onSuccess(Map<String, String> var1);

        public abstract void onError(int var1);
    }

    public static abstract class ApplyEthernetConfigListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        ApplyEthernetConfigListener.this.onSuccess();
                    } else {
                        ApplyEthernetConfigListener.this.onError(retCode);
                    }
                }
            });
        }

        public abstract void onSuccess();

        public abstract void onError(int var1);
    }

    public static abstract class GetEthernetInfoListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode, byte[] data) {
            final EthernetInfo ethInfo = new EthernetInfo();
            if (retCode == 0 && data != null) {
                ethInfo.fromBinary(data);
            }
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        GetEthernetInfoListener.this.onSuccess(ethInfo);
                    } else {
                        GetEthernetInfoListener.this.onError(retCode);
                    }
                }
            });
        }

        public abstract void onSuccess(EthernetInfo var1);

        public abstract void onError(int var1);
    }

    public static abstract class SetEthernetInfoListener {
        private Handler uiHandler = new Handler(Looper.getMainLooper());

        protected final void onEvent(final int retCode) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (retCode == 0) {
                        SetEthernetInfoListener.this.onSuccess();
                    } else {
                        SetEthernetInfoListener.this.onError(retCode);
                    }
                }
            });
        }

        public abstract void onSuccess();

        public abstract void onError(int var1);
    }

    public static class Query {
        private List<String> queryItems = new ArrayList<String>();

        private Query() {
        }

        private Query(String ... items) {
            for (String item : items) {
                this.queryItems.add(item);
            }
        }

        public static Query create(String ... items) {
            return new Query(items);
        }

        public static Query create() {
            return new Query();
        }

        public Query join(String item) {
            this.queryItems.add(item);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = this.queryItems.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                sb.append('|');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
    }
}

