/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import com.landicorp.android.eptapi.dock.DockPort;
import com.landicorp.android.eptapi.dock.Docker;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BTDocker
extends Docker {
    private static final Logger logger = Logger.getLogger(BTDocker.class);
    private static Map<String, BTDocker> DOCKERS = new ConcurrentHashMap<String, BTDocker>();
    private static Map<String, DockPort> SERIAL_PORTS = new ConcurrentHashMap<String, DockPort>();

    public static BTDocker getInstance() {
        return BTDocker.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTDocker getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, BTDocker> map = DOCKERS;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, "BT");
            if (DOCKERS.containsKey(key)) {
                return DOCKERS.get(key);
            }
            BTDocker docker = new BTDocker(packageName, "BT");
            DOCKERS.put(key, docker);
            return docker;
        }
    }

    private BTDocker(String packageName, String dockerName) {
        super(packageName, dockerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockPort getDockPort(String portName) {
        Precondition.checkNotEmpty(portName);
        Map<String, DockPort> map = SERIAL_PORTS;
        synchronized (map) {
            String key = DeviceKeys.createKey(this.packageName, this.dockerName, portName);
            if (SERIAL_PORTS.containsKey(key)) {
                return SERIAL_PORTS.get(key);
            }
            DockPort serialPort = new DockPort(this.packageName, this.dockerName, portName);
            SERIAL_PORTS.put(key, serialPort);
            return serialPort;
        }
    }
}

