/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device.beeper;

import android.media.AudioTrack;
import com.landicorp.android.eptapi.device.beeper.SinWave;

public class AudioBeeper {
    public static final int RATE = 44100;
    public static final float MAXVOLUME = 100.0f;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int DOUBLE = 3;
    float volume;
    int channel;
    int length;
    int waveLen;
    int Hz;
    byte[] wave = new byte[44100];
    AudioTrack audioTrack;

    public void start(int rate) {
        this.stop();
        if (rate > 0) {
            this.Hz = rate;
            this.waveLen = 44100 / this.Hz;
            this.length = this.waveLen * this.Hz;
            this.audioTrack = new AudioTrack(3, 44100, 3, 3, this.length, 1);
            this.wave = SinWave.sin(this.wave, this.waveLen, this.length);
            if (this.audioTrack != null) {
                this.audioTrack.play();
            }
        }
    }

    public void play() {
        if (this.audioTrack != null) {
            this.audioTrack.write(this.wave, 0, this.length);
        }
    }

    public void stop() {
        if (this.audioTrack != null) {
            this.audioTrack.stop();
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.audioTrack != null) {
            switch (this.channel) {
                case 1: {
                    this.audioTrack.setStereoVolume(volume / 100.0f, 0.0f);
                    break;
                }
                case 2: {
                    this.audioTrack.setStereoVolume(0.0f, volume / 100.0f);
                    break;
                }
                case 3: {
                    this.audioTrack.setStereoVolume(volume / 100.0f, volume / 100.0f);
                }
            }
        }
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.setVolume(this.volume);
    }
}

