/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.HashMap;
import java.util.Map;

public class UsbDevice {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_HANDLE = 140;
    public static final int ERROR_DEVICE = 141;
    private static final Map<String, UsbDevice> INSTANCES = new HashMap<String, UsbDevice>();
    private String packageName;
    private UsbType usbType;

    public static UsbDevice getInstance(UsbType type) {
        return UsbDevice.getInstance(MasterController.getInstance().getDefaultAppName(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbDevice getInstance(String packageName, UsbType type) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotNull(type);
        Map<String, UsbDevice> map = INSTANCES;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, type.toString());
            if (INSTANCES.containsKey(key)) {
                return INSTANCES.get(key);
            }
            UsbDevice device = new UsbDevice(packageName, type);
            INSTANCES.put(key, device);
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, UsbDevice> map = INSTANCES;
        synchronized (map) {
            for (String key : INSTANCES.keySet()) {
                if (!DeviceKeys.matchPackageName(key, packageName)) continue;
                INSTANCES.remove(key);
            }
        }
    }

    private UsbDevice(String packageName, UsbType type) {
        this.packageName = packageName;
        this.usbType = type;
    }

    public int open(final int mode) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode);
            }
        }.invoke(5653);
    }

    public int close() {
        return new RemoteInvoker(){}.invoke(5654);
    }

    public int write(final byte[] buffer, final IntegerBuffer actLen, final int timeoutMs) {
        Precondition.checkNotNull(buffer);
        Precondition.checkNotNull(actLen);
        Precondition.checkArgument(timeoutMs >= 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(buffer);
                data.writeInt(timeoutMs);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (actLen != null) {
                    actLen.setData(reply.readInt());
                }
            }
        }.invoke(5655);
    }

    public int read(final int expectedLen, final BytesBuffer buffer, final int timeoutMs) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(timeoutMs >= 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(expectedLen);
                data.writeInt(timeoutMs);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (buffer != null) {
                    buffer.setData(reply.createByteArray());
                }
            }
        }.invoke(5656);
    }

    public int clearRx() {
        return new RemoteInvoker(){}.invoke(5657);
    }

    public int ifRxEmpty(final IntegerBuffer status) {
        Precondition.checkNotNull(status);
        return new RemoteInvoker(){

            @Override
            protected void onResponse(Parcel reply) {
                if (status != null) {
                    status.setData(reply.readInt());
                }
            }
        }.invoke(5658);
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int code) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInt(UsbDevice.this.usbType.ordinal());
                this.onRequest(data);
                MasterController.getInstance().request(UsbDevice.this.packageName, code, data, reply);
                int result = reply.readInt();
                this.onResponse(reply);
                int n = result;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }

    public static enum UsbType {
        HIDKBD,
        CDC,
        HIDBIDIR;

    }
}

