/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.HashMap;
import java.util.Map;

public class UsbCdcDevice {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_HANDLE = 140;
    public static final int ERROR_DEVICE = 141;
    private static final Map<String, UsbCdcDevice> INSTANCES = new HashMap<String, UsbCdcDevice>();
    private String packageName;
    private MasterController mMCtl = MasterController.getInstance();

    public static UsbCdcDevice getInstance() {
        return UsbCdcDevice.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbCdcDevice getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, UsbCdcDevice> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(packageName)) {
                return INSTANCES.get(packageName);
            }
            UsbCdcDevice device = new UsbCdcDevice(packageName);
            INSTANCES.put(packageName, device);
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, UsbCdcDevice> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(packageName)) {
                INSTANCES.remove(packageName);
            }
        }
    }

    private UsbCdcDevice(String packageName) {
        this.packageName = packageName;
    }

    public int open(final int mode) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode);
            }
        }.invoke(5643);
    }

    public int close() {
        return new RemoteInvoker(){}.invoke(5644);
    }

    public int write(final byte[] buffer, final IntegerBuffer actLen, final int timeoutMs) {
        Precondition.checkNotNull(buffer);
        Precondition.checkNotNull(actLen);
        Precondition.checkArgument(timeoutMs >= 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(buffer);
                data.writeInt(timeoutMs);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (actLen != null) {
                    actLen.setData(reply.readInt());
                }
            }
        }.invoke(5645);
    }

    public int read(final int expectedLen, final BytesBuffer buffer, final int timeoutMs) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(timeoutMs >= 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(expectedLen);
                data.writeInt(timeoutMs);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (buffer != null) {
                    buffer.setData(reply.createByteArray());
                }
            }
        }.invoke(5646);
    }

    public int clearRx() {
        return new RemoteInvoker(){}.invoke(5647);
    }

    public int ifRxEmpty(final IntegerBuffer status) {
        Precondition.checkNotNull(status);
        return new RemoteInvoker(){

            @Override
            protected void onResponse(Parcel reply) {
                if (status != null) {
                    status.setData(reply.readInt());
                }
            }
        }.invoke(5648);
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int code) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                this.onRequest(data);
                UsbCdcDevice.this.mMCtl.request(UsbCdcDevice.this.packageName, code, data, reply);
                int result = reply.readInt();
                this.onResponse(reply);
                int n = result;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }
}

