/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.text.TextUtils;
import com.landicorp.android.eptapi.device.Channel;
import com.landicorp.android.eptapi.device.SerialPort;
import com.landicorp.android.eptapi.dock.BTDocker;
import com.landicorp.android.eptapi.dock.DockPort;
import com.landicorp.android.eptapi.dock.WifiDocker;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.HashMap;
import java.util.Map;

public class UartDevice {
    public static final int ERROR_NONE = 0;
    public static final String DEVICE_NAME = "USB_CDC_ACM";
    private static final Map<String, UartDevice> INSTANCES = new HashMap<String, UartDevice>();
    private String deviceName;
    private String packageName;
    private IOChannel ioChannel;

    public static UartDevice getInstance(String deviceName) {
        return UartDevice.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UartDevice getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, UartDevice> map = INSTANCES;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (INSTANCES.containsKey(key)) {
                return INSTANCES.get(key);
            }
            UartDevice device = new UartDevice(packageName, deviceName);
            INSTANCES.put(key, device);
            return device;
        }
    }

    private UartDevice(String packageName, String deviceName) {
        this.packageName = packageName;
        this.deviceName = TextUtils.isEmpty((CharSequence)deviceName) ? DEVICE_NAME : deviceName;
        this.init(Channel.WIRED);
    }

    public void init(Channel channel) {
        Precondition.checkNotNull(channel);
        switch (channel) {
            case WIFI: 
            case BT: {
                this.ioChannel = WirelessChannel.newChannel(channel, this.packageName, this.deviceName);
                break;
            }
            default: {
                this.ioChannel = WiredChannel.newChannel(this.deviceName);
            }
        }
    }

    public int open(BaudRate bps, Parity par, DataBit dbs) {
        Precondition.checkNotNull(bps);
        Precondition.checkNotNull(par);
        Precondition.checkNotNull(dbs);
        return this.ioChannel.open(bps.value, par.value, dbs.value);
    }

    public int close() {
        return this.ioChannel.close();
    }

    public int read(byte[] buffer, int timeout) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(timeout >= 0);
        return this.ioChannel.read(buffer, timeout);
    }

    public int read(byte[] buffer, int offset, int len, int timeout) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(offset >= 0 && len >= 0);
        Precondition.checkArgument(timeout >= 0);
        return this.ioChannel.read(buffer, offset, len, timeout);
    }

    public int write(byte[] buffer, int timeout) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(timeout >= 0);
        return this.ioChannel.write(buffer, timeout);
    }

    public boolean isRxEmpty() {
        return this.ioChannel.isRxEmpty();
    }

    public boolean clearRxBuffer() {
        return this.ioChannel.clearRxBuffer();
    }

    private static interface IOChannel {
        public int open(int var1, int var2, int var3);

        public int close();

        public int read(byte[] var1, int var2);

        public int read(byte[] var1, int var2, int var3, int var4);

        public int write(byte[] var1, int var2);

        public boolean isRxEmpty();

        public boolean clearRxBuffer();
    }

    private static class WirelessChannel
    implements IOChannel {
        private DockPort dockPort;

        static WirelessChannel newChannel(Channel channel, String packageName, String deviceName) {
            DockPort dockPort = channel == Channel.WIFI ? WifiDocker.getInstance(packageName).getDockPort(deviceName) : BTDocker.getInstance(packageName).getDockPort(deviceName);
            return new WirelessChannel(dockPort);
        }

        private WirelessChannel(DockPort dockPort) {
            this.dockPort = dockPort;
        }

        @Override
        public int open(int bps, int par, int dbs) {
            return this.dockPort.open(bps, par, dbs);
        }

        @Override
        public int close() {
            return this.dockPort.close();
        }

        @Override
        public int read(byte[] buffer, int timeout) {
            if (buffer == null) {
                return -1;
            }
            int expectedLen = buffer.length;
            BytesBuffer dataBuffer = new BytesBuffer();
            int ret = this.dockPort.read(expectedLen, dataBuffer, timeout);
            if (ret != 0) {
                return -1;
            }
            if (dataBuffer.getData() == null) {
                return 0;
            }
            int copySize = Math.min(dataBuffer.getData().length, buffer.length);
            System.arraycopy(dataBuffer.getData(), 0, buffer, 0, copySize);
            return copySize;
        }

        @Override
        public int read(byte[] buffer, int offset, int len, int timeout) {
            if (buffer == null) {
                return -1;
            }
            BytesBuffer dataBuffer = new BytesBuffer();
            int ret = this.dockPort.read(len, dataBuffer, timeout);
            if (ret != 0) {
                return -1;
            }
            if (dataBuffer.getData() == null) {
                return 0;
            }
            int copySize = Math.min(dataBuffer.getData().length, len);
            System.arraycopy(dataBuffer.getData(), 0, buffer, offset, copySize);
            return copySize;
        }

        @Override
        public int write(byte[] buffer, int timeout) {
            int ret = this.dockPort.write(buffer, timeout);
            return ret == 0 ? buffer.length : -1;
        }

        @Override
        public boolean isRxEmpty() {
            return this.dockPort.isBufferEmpty();
        }

        @Override
        public boolean clearRxBuffer() {
            return this.dockPort.clearBuffer() == 0;
        }
    }

    private static class WiredChannel
    implements IOChannel {
        private SerialPort serialPort;

        static WiredChannel newChannel(String deviceName) {
            return new WiredChannel(deviceName);
        }

        private WiredChannel(String deviceName) {
            this.serialPort = new SerialPort(deviceName);
        }

        @Override
        public int open(int bps, int par, int dbs) {
            int ret = this.serialPort.open();
            if (ret != 0) {
                return ret;
            }
            return this.serialPort.init(bps, par, dbs);
        }

        @Override
        public int close() {
            return this.serialPort.close();
        }

        @Override
        public int read(byte[] buffer, int timeout) {
            return this.serialPort.read(buffer, timeout);
        }

        @Override
        public int read(byte[] buffer, int offset, int len, int timeout) {
            return this.serialPort.read(buffer, offset, len, timeout);
        }

        @Override
        public int write(byte[] buffer, int timeout) {
            return this.serialPort.write(buffer, timeout);
        }

        @Override
        public boolean isRxEmpty() {
            return this.serialPort.isBufferEmpty(true);
        }

        @Override
        public boolean clearRxBuffer() {
            return this.serialPort.clearInputBuffer() == 0;
        }
    }

    public static enum DataBit {
        DBS_7(7),
        DBS_8(8);

        private int value;

        private DataBit(int value) {
            this.value = value;
        }
    }

    public static enum Parity {
        EVEN('E'),
        ODD('O'),
        NONE('N');

        private char value;

        private Parity(char value) {
            this.value = value;
        }
    }

    public static enum BaudRate {
        BPS_1200(1),
        BPS_2400(2),
        BPS_4800(3),
        BPS_9600(4),
        BPS_19200(7),
        BPS_57600(8),
        BPS_115200(9),
        BPS_38400(10);

        private int value;

        private BaudRate(int value) {
            this.value = value;
        }
    }
}

