/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.Precondition;

public class SerialPort {
    public static final int BPS_1200 = 1;
    public static final int BPS_2400 = 2;
    public static final int BPS_4800 = 3;
    public static final int BPS_9600 = 4;
    public static final int BPS_14400 = 5;
    public static final int BPS_28800 = 6;
    public static final int BPS_38400 = 10;
    public static final int BPS_19200 = 7;
    public static final int BPS_57600 = 8;
    public static final int BPS_115200 = 9;
    public static final int PAR_NOPAR = 78;
    public static final int PAR_EVEN = 69;
    public static final int PAR_ODD = 79;
    public static final int DBS_7 = 7;
    public static final int DBS_8 = 8;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_OTHER = 1;
    public static final int ERROR_DEVICE_DISABLE = 141;
    private static final int INVALID_DEV_HANDLE = -1;
    private int devHandle = -1;
    private String devName;

    public SerialPort(String devName) {
        Precondition.checkNotEmpty(devName);
        this.devName = devName;
    }

    public native int open();

    public native int init(int var1, int var2, int var3);

    public native int read(byte[] var1, int var2);

    public int read(byte[] buffer, int offset, int len, int timeout) {
        if (!SerialPort.verifyParameter(buffer, offset, len, timeout)) {
            return 139;
        }
        byte[] data = BytesUtil.subBytes(buffer, offset, len);
        if (data != null && data.length != len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ret = this.read(data, timeout);
        if (ret > 0 && data != null) {
            System.arraycopy(data, 0, buffer, offset, ret);
        }
        return ret;
    }

    public native int write(byte[] var1, int var2);

    public int write(byte[] data, int offset, int len, int timeout) {
        if (!SerialPort.verifyParameter(data, offset, len, timeout)) {
            return 139;
        }
        byte[] out = BytesUtil.subBytes(data, offset, len);
        if (out != null && out.length != len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.write(out, timeout);
    }

    private static boolean verifyParameter(byte[] data, int offset, int len, int timeout) {
        if (data == null || data.length == 0) {
            return false;
        }
        if (timeout < 0 || offset < 0 || len < 0) {
            return false;
        }
        return offset < data.length && offset + len <= data.length;
    }

    public native int close();

    public native int clearInputBuffer();

    public native boolean isBufferEmpty(boolean var1);

    public native int writeMs(byte[] var1, int var2);

    public native int readMs(int var1, BytesBuffer var2, int var3);

    static {
        System.loadLibrary("eptand_jni");
    }
}

