/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.device.Channel;
import com.landicorp.android.eptapi.device.UartDevice;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Arrays;

public class Scanner {
    private static final Logger logger = Logger.getLogger(Scanner.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_IS_ALEADY_OPEN = 137;
    public static final int ERROR_DEVICE_NOT_EXIST = 141;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private volatile boolean isScanning = false;
    private volatile boolean isOpen = false;
    private String packageName;
    private Thread listenThread;
    private UartDevice uartDevice;
    private OnScanListener onScanListener;
    private Decoder decoder = Decoder.UTF8;

    public Scanner(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public Scanner(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.packageName = packageName;
        this.uartDevice = UartDevice.getInstance(packageName, deviceName);
        this.initChannel(Channel.WIRED);
    }

    public void initChannel(Channel channel) {
        this.uartDevice.init(channel);
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public void setOnScanListener(OnScanListener listener) {
        this.onScanListener = listener == null ? new OnScanListener(){

            @Override
            public void onScanSuccess(String code) {
            }

            @Override
            public void onScanFail(int error) {
            }

            @Override
            public void onCrash() {
            }
        } : listener;
    }

    public int open() {
        if (this.isOpen) {
            return 0;
        }
        int ret = this.uartDevice.open(UartDevice.BaudRate.BPS_9600, UartDevice.Parity.NONE, UartDevice.DataBit.DBS_8);
        if (ret != 0) {
            return ret;
        }
        this.isOpen = true;
        return 0;
    }

    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.stopListen();
        this.uartDevice.close();
        this.isOpen = false;
        this.isScanning = false;
    }

    public void scan() {
        if (!this.isOpen) {
            this.onScanListener.onScanFail(1);
            return;
        }
        if (this.isScanning) {
            return;
        }
        this.stopListen();
        this.isScanning = true;
        this.listenThread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.debug("-------------------listen thread started----------------", new Object[0]);
                byte[] buffer = new byte[256];
                StringBuilder result = new StringBuilder();
                Scanner.this.uartDevice.clearRxBuffer();
                while (!Scanner.this.listenThread.isInterrupted()) {
                    Arrays.fill(buffer, (byte)0);
                    int readLen = Scanner.this.uartDevice.read(buffer, 200);
                    logger.debug("# readLen = " + readLen, new Object[0]);
                    if (readLen == -1) {
                        Scanner.this.notifyState(1, result.toString());
                        Scanner.this.isScanning = false;
                        break;
                    }
                    if (readLen == 0) continue;
                    byte[] received = Arrays.copyOf(buffer, readLen);
                    logger.debug("# received data = " + BytesUtil.bytes2HexString(received), new Object[0]);
                    result.append(Scanner.this.decoder.fromBytes(Scanner.this.parseContent(received)));
                    if (!Scanner.this.isEndOfCotent(received)) continue;
                    logger.debug("# notifyData | result = " + result, new Object[0]);
                    Scanner.this.notifyState(0, result.toString());
                    result.setLength(0);
                }
                logger.debug("-------------------listen thread exit----------------", new Object[0]);
            }
        });
        this.listenThread.start();
    }

    private boolean isEndOfCotent(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return false;
        }
        int len = buffer.length;
        return buffer[len - 1] == 13 || buffer[len - 1] == 10;
    }

    private byte[] parseContent(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return buffer;
        }
        int eocCount = 0;
        int len = buffer.length;
        if (buffer[len - 1] == 13 || buffer[len - 1] == 10) {
            eocCount = 1;
            if (len > 1 && buffer[len - 1] == 10 && buffer[len - 2] == 13) {
                eocCount = 2;
            }
            return Arrays.copyOfRange(buffer, 0, len - eocCount);
        }
        return buffer;
    }

    private void stopListen() {
        if (this.listenThread != null) {
            logger.debug("-------------------stopListen----------------", new Object[0]);
            if (this.listenThread.isAlive()) {
                this.listenThread.interrupt();
                try {
                    this.listenThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.listenThread = null;
        }
    }

    private void notifyState(int errorCode, String barcode) {
        if (this.onScanListener != null) {
            Parcel p = Parcel.obtain();
            p.writeInt(errorCode);
            if (barcode != null) {
                p.writeString(barcode);
            }
            p.setDataPosition(0);
            this.onScanListener.notifyData(p);
        }
    }

    public static abstract class OnScanListener
    extends RemoteListener {
        public static final int ERROR_COMMERR = 1;
        public static final int ERROR_TIMEOUT = 2;
        public static final int ERROR_FAIL = 3;

        public OnScanListener() {
        }

        public OnScanListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        public final int getEventId() {
            return 0;
        }

        @Override
        protected final void onListened(Parcel data) {
            int ret = data.readInt();
            String code = data.readString();
            if (ret == 0) {
                this.onScanSuccess(code);
            } else {
                this.onScanFail(ret);
            }
        }

        public abstract void onScanSuccess(String var1);

        public abstract void onScanFail(int var1);
    }

    public static enum Decoder {
        ISO8859_1,
        UTF8,
        GBK,
        GB2312;


        public String fromBytes(byte[] data) {
            if (data == null || data.length == 0) {
                return "";
            }
            switch (this) {
                case UTF8: {
                    return BytesUtil.fromUtf8(data);
                }
                case GBK: {
                    return BytesUtil.fromGBK(data);
                }
                case GB2312: {
                    return BytesUtil.fromGB2312(data);
                }
            }
            return BytesUtil.fromBytes(data);
        }
    }
}

