/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class PrintableImage {
    static final Logger logger = Logger.getLogger(PrintableImage.class);
    private InputStream imageInputStream;
    private int h;
    private int w;
    private int bitCount;
    private byte[] imageData;

    private PrintableImage(InputStream is) {
        this.imageInputStream = is;
    }

    public static PrintableImage create(String fileName) throws FileNotFoundException {
        PrintableImage image = new PrintableImage(new BufferedInputStream(new FileInputStream(fileName)));
        image.loadImage();
        return image;
    }

    public static PrintableImage create(InputStream is) {
        PrintableImage image = new PrintableImage(is instanceof BufferedInputStream ? is : new BufferedInputStream(is));
        image.loadImage();
        return image;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public int getHeight() {
        return this.h;
    }

    public int getWidth() {
        return this.w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage() {
        if (this.imageInputStream == null) {
            logger.error("imageInputStream is null", new Object[0]);
            return;
        }
        try {
            int lineSize;
            int headerLen = 14;
            byte[] header = new byte[headerLen];
            this.imageInputStream.read(header, 0, headerLen);
            if (!"BM".equals(new String(header, 0, 2, "GBK"))) {
                logger.error("load image not bitmap", new Object[0]);
                return;
            }
            int infoLen = 40;
            byte[] info = new byte[infoLen];
            this.imageInputStream.read(info, 0, infoLen);
            this.w = this.getInt(info, 4);
            this.h = this.getInt(info, 8);
            int outputH = (this.h + 7) / 8 * 8;
            int compress = this.getInt(info, 16);
            if (compress != 0) {
                logger.error("load image (compress != 0)", new Object[0]);
                return;
            }
            this.bitCount = this.getShort(info, 14);
            if (this.bitCount > 1) {
                logger.error("load image (bitCount > 1)", new Object[0]);
                return;
            }
            int outputLineSize = lineSize = (this.getWidth() * this.bitCount + 31) / 32 * 4;
            int offset = outputLineSize * this.getHeight();
            int bufferSize = outputLineSize * outputH;
            byte[] bmpData = new byte[bufferSize];
            this.imageInputStream.read(bmpData, 0, 8);
            boolean needRevert = bmpData[0] != -1;
            Arrays.fill(bmpData, ~bmpData[0]);
            byte[] readBuffer = new byte[lineSize];
            for (int i = 0; i < this.getHeight(); ++i) {
                this.imageInputStream.read(readBuffer, 0, lineSize);
                int readOffset = offset - (i + 1) * outputLineSize;
                System.arraycopy(readBuffer, 0, bmpData, readOffset, outputLineSize);
            }
            if (needRevert) {
                this.reverseImageColor(bmpData);
            }
            this.imageData = new byte[this.calcImageDataSize(this.w * this.h, this.w)];
            this.transformImageData(this.imageData, bmpData, this.h, this.w);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.imageInputStream);
        }
    }

    private int calcImageDataSize(int bmpData, int w) {
        int hight;
        int rest;
        if (bmpData % w != 0) {
            logger.warn("the bitmap is error!!", new Object[0]);
        }
        if ((rest = (hight = bmpData / w) % 8) == 0) {
            return bmpData;
        }
        return (hight += 8 - rest) * w;
    }

    private void reverseImageColor(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = ~data[i];
        }
    }

    private int transformImageData(byte[] imageData, byte[] bmpData, int height, int width) {
        int i;
        logger.debug("imageData len = " + imageData.length, new Object[0]);
        logger.debug("bmpData len = " + bmpData.length, new Object[0]);
        logger.debug("height[" + height + "] width[" + width + "]", new Object[0]);
        int offset = 0;
        int row = 0;
        int col = 0;
        int pitch = 0;
        int real_len = 0;
        pitch = (height + 7) / 8;
        real_len = (width + 31) / 32 * 4;
        int rec = 8 - height % 8;
        for (int k = 0; k < pitch; ++k) {
            for (col = 0; col < width; ++col) {
                i = 0;
                int num = 0;
                row = 0;
                while (row < 8) {
                    if ((bmpData[k * 8 * real_len + row * real_len + col / 8] & 128 >> col % 8) != 0) {
                        int n = offset;
                        imageData[n] = (byte)(imageData[n] | 1 << num);
                    }
                    ++row;
                    ++num;
                }
                ++offset;
            }
        }
        for (i = 0; i < width; ++i) {
            if (height % 8 == 0) continue;
            imageData[height / 8 * width + i] = (byte)(imageData[height / 8 * width + i] & 255 >> rec);
        }
        return 0;
    }

    private int getInt(byte[] four, int offset) {
        return (four[offset + 3] & 0xFF) << 24 | (four[offset + 2] & 0xFF) << 16 | (four[offset + 1] & 0xFF) << 8 | four[offset] & 0xFF;
    }

    private int getShort(byte[] four, int offset) {
        return (four[offset + 1] & 0xFF) << 8 | four[offset] & 0xFF;
    }
}

