/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.app.Activity;
import android.os.Parcel;
import com.landicorp.android.eptapi.card.data.MagAuthKey;
import com.landicorp.android.eptapi.card.data.MagAuthMode;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MagCardReader {
    static final Logger logger = Logger.getLogger(MagCardReader.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_HANDLE = 140;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_CMD_NOSUPPORT = 48;
    public static final int ERROR_DLOPEN_FAIL = 49;
    public static final int ERROR_DLSYM_FAIL = 50;
    public static final int TRK1 = 1;
    public static final int TRK2 = 2;
    public static final int TRK3 = 4;
    public static final int CMD_SET_PINPAD_TYPE = -2147193599;
    public static final int CMD_SET_ENCRYPT_TRACK = -2147193598;
    public static final int CMD_SET_TRKDATA_TYPE = -2147193597;
    public static final int CMD_GET_PINPAD_TYPE = 1074031873;
    public static final int CMD_GET_ENCRYPT_TRACK = 1074031874;
    public static final int CMD_GET_TRKDATA_TYPE = 1074031875;
    private static Map<String, MagCardReader> sInstances = new ConcurrentHashMap<String, MagCardReader>();
    private boolean mIsLrcEnabled = true;
    private boolean mIsCtrlFlagEnabled = false;
    private int mTrk = 6;
    private int mOnSearchListenerID = 0;
    private String packageName;
    private MasterController mMCtl = MasterController.getInstance();

    public static MagCardReader getInstance() {
        return MagCardReader.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagCardReader getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, MagCardReader> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            MagCardReader instance = new MagCardReader();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, MagCardReader> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                sInstances.remove(packageName);
            }
        }
    }

    private MagCardReader() {
    }

    public void setLRCCheckEnabled(boolean isLRCEnabled) {
        this.mIsLrcEnabled = isLRCEnabled;
    }

    public void setCtrlFlagEnabled(boolean isCtrlFlagEnabled) {
        this.mIsCtrlFlagEnabled = isCtrlFlagEnabled;
    }

    public void enableTrack(int id) {
        if (!this.checkTrackParamValid(id)) {
            return;
        }
        this.mTrk |= id;
    }

    public void disableTrack(int id) {
        if (!this.checkTrackParamValid(id)) {
            return;
        }
        this.mTrk &= ~id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(Activity a, OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(0);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, a);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(0);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(int trk, OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        if (!this.checkTrackParamValid(trk)) {
            return;
        }
        this.mTrk = trk;
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(0);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(OnSearchRawTrackListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchRawTrackListener onSearchRawTrackListener = listener;
        synchronized (onSearchRawTrackListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(1);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(OnSearchTrackListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1, new String[3]);
            return;
        }
        OnSearchTrackListener onSearchTrackListener = listener;
        synchronized (onSearchTrackListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(1);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchCard(Activity a, int trk, OnSearchListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSearchListener onSearchListener = listener;
        synchronized (onSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        if (!this.checkTrackParamValid(trk)) {
            return;
        }
        this.mTrk = trk;
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(0);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        try {
            this.mMCtl.setTaskID(this.packageName, a);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 1, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public synchronized void stopSearch() throws RequestException {
        if (this.stopSearchLocal()) {
            this.mMCtl.request(this.packageName, 2);
        }
    }

    private synchronized boolean stopSearchLocal() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mOnSearchListenerID);
        if (l == null) {
            return false;
        }
        this.mMCtl.uninstallListener(this.packageName, l);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void searchAuthCard(MagAuthKey authKey, MagAuthMode authMode, OnAuthSearchListener listener) throws RequestException {
        Precondition.checkNotNull(authKey);
        Precondition.checkNotNull(authMode);
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSearchListenerID)) {
            logger.error("### searchCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnAuthSearchListener onAuthSearchListener = listener;
        synchronized (onAuthSearchListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeInt(this.mIsLrcEnabled ? 1 : 0);
        data.writeInt(this.mIsCtrlFlagEnabled ? 1 : 0);
        data.writeByteArray(authKey.toBinary());
        data.writeByteArray(authMode.toBinary());
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mOnSearchListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 3, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int magIOControl(int cmd, byte[] param, BytesBuffer out) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(cmd);
            data.writeByteArray(param);
            this.mMCtl.request(this.packageName, 4, data, reply);
            int ret = reply.readInt();
            if (ret == 0 && out != null) {
                out.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(int cmd, byte[] param, BytesBuffer out) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(cmd);
            data.writeByteArray(param);
            this.mMCtl.request(this.packageName, 4, data, reply);
            int ret = reply.readInt();
            if (ret == 0 && out != null) {
                out.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    private boolean checkTrackParamValid(int trk) {
        switch (trk) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static class Track2Data {
        final int status;
        final int icFlag;
        final String expiredDate;
        final String cardNo;

        private Track2Data(int status, int icFlag, String expiredDate, String cardNo) {
            this.status = status;
            this.icFlag = icFlag;
            this.expiredDate = expiredDate;
            this.cardNo = cardNo;
        }

        public static Track2Data create(int status, int icFlag, String expiredDate, String cardNo) {
            return new Track2Data(status, icFlag, expiredDate, cardNo);
        }

        public int getStatus() {
            return this.status;
        }

        public int getIcFlag() {
            return this.icFlag;
        }

        public String getExpiredDate() {
            return this.expiredDate;
        }

        public String getCardNo() {
            return this.cardNo;
        }
    }

    public static abstract class OnAuthSearchListener
    extends BaseListener {
        private static final int ID = 258;
        public static final int TRACK_STATE_SUCCESS = 0;
        public static final int TRACK_STATE_NULL = 1;
        public static final int TRACK_STATE_HEADERR = 2;
        public static final int TRACK_STATE_PARERR = 3;
        public static final int TRACK_STATE_TAILERR = 4;
        public static final int TRACK_STATE_LRCERR = 5;
        public static final int TRACK_STATE_ENDERR = 6;
        public static final int TRACK_STATE_JISS_SUCCESS = 128;

        public OnAuthSearchListener() {
        }

        public OnAuthSearchListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            MagCardReader reader = this.reader;
            OnAuthSearchListener onAuthSearchListener = this;
            synchronized (onAuthSearchListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            int ret = data.readInt();
            if (ret != 0) {
                this.onFail(ret);
                return;
            }
            int status = data.readInt();
            int icFlag = data.readInt();
            Track2Data track2Data = Track2Data.create(status, icFlag >= 48 ? icFlag - 48 : icFlag, BytesUtil.fromBytes(data.createByteArray()), BytesUtil.fromBytes(data.createByteArray()));
            int[] trackState = new int[3];
            String[] tracks = new String[3];
            for (int i = 0; i < 3; ++i) {
                trackState[i] = data.readInt();
                byte[] trackData = data.createByteArray();
                tracks[i] = trackData == null ? "" : BytesUtil.bytes2HexString(trackData);
            }
            this.onCardStriped(trackState, tracks, track2Data);
        }

        @Override
        public final int getEventId() {
            return 258;
        }

        public abstract void onCardStriped(int[] var1, String[] var2, Track2Data var3);

        public abstract void onFail(int var1);
    }

    public static abstract class OnSearchTrackListener
    extends BaseListener {
        private static final int ID = 257;

        public OnSearchTrackListener() {
        }

        public OnSearchTrackListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            MagCardReader reader = this.reader;
            OnSearchTrackListener onSearchTrackListener = this;
            synchronized (onSearchTrackListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            int ret = data.readInt();
            int[] flags = new int[3];
            String[] track = new String[3];
            for (int i = 0; i < 3; ++i) {
                flags[i] = data.readInt();
                byte[] trackData = data.createByteArray();
                track[i] = trackData == null ? "" : BytesUtil.fromBytes(trackData);
            }
            if (ret != 65281 && ret != 0) {
                this.onFail(ret, track);
                return;
            }
            this.onCardStriped(flags, track);
        }

        @Override
        public final int getEventId() {
            return 257;
        }

        public abstract void onCardStriped(int[] var1, String[] var2);

        public abstract void onFail(int var1, String[] var2);
    }

    public static abstract class OnSearchRawTrackListener
    extends BaseListener {
        private static final int ID = 257;

        public OnSearchRawTrackListener() {
        }

        public OnSearchRawTrackListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            MagCardReader reader = this.reader;
            OnSearchRawTrackListener onSearchRawTrackListener = this;
            synchronized (onSearchRawTrackListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            int ret = data.readInt();
            int[] flags = new int[3];
            byte[][] track = new byte[3][];
            for (int i = 0; i < 3; ++i) {
                flags[i] = data.readInt();
                track[i] = data.createByteArray();
            }
            if (ret != 65281 && ret != 0) {
                this.onFail(ret);
                return;
            }
            this.onCardStriped(flags, track);
        }

        @Override
        public final int getEventId() {
            return 257;
        }

        public abstract void onCardStriped(int[] var1, byte[][] var2);

        public abstract void onFail(int var1);
    }

    public static abstract class OnSearchListener
    extends BaseListener {
        private static final int ID = 257;

        public OnSearchListener() {
        }

        public OnSearchListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            int i;
            MagCardReader reader = this.reader;
            OnSearchListener onSearchListener = this;
            synchronized (onSearchListener) {
                this.setStarted(false);
            }
            reader.stopSearchLocal();
            int ret = data.readInt();
            boolean isRetError = ret != 0;
            boolean[] hasTrack = new boolean[3];
            int[] flags = new int[3];
            String[] track = new String[3];
            for (i = 0; i < 3; ++i) {
                flags[i] = data.readInt();
                track[i] = data.readString();
            }
            if (isRetError && data.dataAvail() == 0) {
                this.onFail(ret);
                return;
            }
            if (ret != 65281 && ret != 0) {
                this.onFail(ret);
                return;
            }
            if (!this.checkValid(flags, track)) {
                this.onFail(65281);
                return;
            }
            for (i = 0; i < 3; ++i) {
                hasTrack[i] = this.isTrackExists(i, flags[i], track[i]);
                if ((reader.mTrk & 1 << i) != 0) continue;
                flags[i] = 0;
                hasTrack[i] = false;
                track[i] = "";
            }
            this.onCardStriped(hasTrack, track);
        }

        @Override
        public final int getEventId() {
            return 257;
        }

        public boolean isTrackExists(int trackno, int trackState, String track) {
            return trackState != 0;
        }

        public boolean checkValid(int[] trackStates, String[] track) {
            for (int state : trackStates) {
                if (state == 1 || state == 0 || state == 128) continue;
                return false;
            }
            return true;
        }

        public abstract void onCardStriped(boolean[] var1, String[] var2);

        public abstract void onFail(int var1);
    }

    private static abstract class BaseListener
    extends RemoteListener {
        public static final int TRACK_STATE_NULL = 0;
        public static final int TRACK_STATE_OK = 1;
        public static final int TRACK_STATE_HEADERR = 2;
        public static final int TRACK_STATE_PARERR = 3;
        public static final int TRACK_STATE_TAILERR = 4;
        public static final int TRACK_STATE_LRCERR = 5;
        public static final int TRACK_STATE_ENDERR = 6;
        public static final int TRACK_STATE_JISS_SUCCESS = 128;
        public static final int ERROR_NONE = 0;
        public static final int ERROR_FAIL = 1;
        public static final int ERROR_NODATA = 2;
        public static final int ERROR_NEEDSTART = 3;
        public static final int ERROR_PARAM = 139;
        public static final int ERROR_HANDLE = 140;
        public static final int ERROR_INVALID = 65281;
        MagCardReader reader;
        boolean started = false;

        public BaseListener() {
        }

        public BaseListener(PausableHandler handler) {
            super(handler);
        }

        public void setReader(MagCardReader reader) {
            this.reader = reader;
        }

        public MagCardReader getReader() {
            return this.reader;
        }

        void setStarted(boolean started) {
            this.started = started;
        }

        boolean isStarted() {
            return this.started;
        }
    }
}

