/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlashLight {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ERROR = 1;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    private static final int STATUS_OPEN_LIGHT = 1;
    private static final int STATUS_CLOSE_LIGHT = 2;
    private static Map<String, FlashLight> INSTANCES = new ConcurrentHashMap<String, FlashLight>();
    private String packageName;
    private MasterController mMctl = MasterController.getInstance();

    public static FlashLight getInstance() {
        return FlashLight.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlashLight getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, FlashLight> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(packageName)) {
                return INSTANCES.get(packageName);
            }
            FlashLight device = new FlashLight();
            device.packageName = packageName;
            INSTANCES.put(packageName, device);
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, FlashLight> map = INSTANCES;
        synchronized (map) {
            INSTANCES.remove(packageName);
        }
    }

    private FlashLight() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open() {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(1);
            this.mMctl.request(this.packageName, 5377, data, reply);
            int n = reply.readInt();
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(2);
            this.mMctl.request(this.packageName, 5377, data, reply);
            int n = reply.readInt();
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBrightness(int lightness) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(lightness);
            this.mMctl.request(this.packageName, 5378, data, reply);
            int n = reply.readInt();
            return n;
        }
        catch (RequestException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }
}

