/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.device.Channel;
import com.landicorp.android.eptapi.device.UartDevice;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"Recycle"})
public class BRScanner {
    static final Logger logger = Logger.getLogger(BRScanner.class);
    private static final byte STX = 2;
    private static final byte ETX = 3;
    private static final byte ACK = 5;
    private static final byte NAK = 21;
    private static final String CMD_START_SCAN = "SW00001";
    private static final String CMD_STOP_SCAN = "SW00000";
    private static final String ACK_DECODE_DATA = "04D00400FF28";
    private static final int SEND_TIMEOUT = 5000;
    private static final int RECV_TIMEOUT = 5000;
    private static final int LISTEN_TIMEOUT = 100;
    static final String DEVICE_NAME = "/ttyACM0";
    private static final Map<String, BRScanner> INSTANCES = new HashMap<String, BRScanner>(5);
    private Thread listenThread;
    private boolean isStarted;
    private String deviceName;
    private UartDevice uartDevice;
    private OnScanListener onScanListener;

    public static BRScanner getInstance() {
        return BRScanner.getInstance(DEVICE_NAME);
    }

    public static BRScanner getInstance(String deviceName) {
        return BRScanner.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BRScanner getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        String key = DeviceKeys.createKey(packageName, deviceName);
        Map<String, BRScanner> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(key)) {
                return INSTANCES.get(key);
            }
            BRScanner scanner = new BRScanner(packageName, deviceName);
            INSTANCES.put(key, scanner);
            return scanner;
        }
    }

    private BRScanner(String packageName, String deviceName) {
        this.deviceName = TextUtils.isEmpty((CharSequence)deviceName) ? DEVICE_NAME : deviceName;
        this.uartDevice = UartDevice.getInstance(packageName, this.deviceName);
        this.initChannel(Channel.WIRED);
    }

    public void initChannel(Channel channel) {
        this.uartDevice.init(channel);
    }

    public boolean startScan(OnScanListener listener) {
        if (this.isStarted) {
            this.stopScan();
        }
        if (!this.openDevice()) {
            return false;
        }
        if (!this.sendRequest(BytesUtil.toBytes(CMD_START_SCAN))) {
            this.closeDevice();
            return false;
        }
        byte[] recvCmd = this.receiveReply();
        if (recvCmd == null || recvCmd.length == 0) {
            this.closeDevice();
            return false;
        }
        if (!Arrays.equals(recvCmd, BytesUtil.toBytes(CMD_START_SCAN))) {
            this.closeDevice();
            return false;
        }
        this.closeDevice();
        this.onScanListener = listener;
        this.startListen();
        return true;
    }

    public boolean stopScan() {
        this.stopListen();
        this.onScanListener = null;
        this.isStarted = false;
        if (!this.openDevice()) {
            return false;
        }
        if (!this.sendRequest(BytesUtil.toBytes(CMD_STOP_SCAN))) {
            this.closeDevice();
            return false;
        }
        byte[] recvCmd = this.receiveReply();
        if (recvCmd == null || recvCmd.length == 0) {
            this.closeDevice();
            return false;
        }
        if (!Arrays.equals(recvCmd, BytesUtil.toBytes(CMD_STOP_SCAN))) {
            this.closeDevice();
            return false;
        }
        this.closeDevice();
        return true;
    }

    private boolean openDevice() {
        int ret = this.uartDevice.open(UartDevice.BaudRate.BPS_9600, UartDevice.Parity.NONE, UartDevice.DataBit.DBS_8);
        if (ret != 0) {
            logger.debug("/// openDevice | open | devName = " + this.deviceName + ", ret = " + ret, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean closeDevice() {
        int ret = this.uartDevice.close();
        logger.debug("/// closeDevice | close | ret = " + ret, new Object[0]);
        return ret == 0;
    }

    private boolean isDataReceived() {
        return !this.uartDevice.isRxEmpty();
    }

    private byte[] receiveData() {
        byte[] buffer = new byte[1024];
        int iRet = this.uartDevice.read(buffer, 100);
        logger.debug("/// receiveData | iRet = " + iRet + ", buffer = " + BytesUtil.bytes2HexString(buffer), new Object[0]);
        return iRet > 0 ? Arrays.copyOf(buffer, iRet) : null;
    }

    private boolean sendRequest(byte[] insData) {
        byte[] cmd = BRScanner.makeCommand(insData);
        logger.debug("/// sendRequest | cmd = " + BytesUtil.bytes2HexString(cmd), new Object[0]);
        int iRet = this.uartDevice.write(cmd, 5000);
        logger.debug("/// sendRequest | write | iRet = " + iRet, new Object[0]);
        if (iRet != cmd.length) {
            return false;
        }
        byte[] ack = new byte[10];
        iRet = this.uartDevice.read(ack, 0, 1, 5000);
        logger.debug("/// sendRequest | read | iRet = " + iRet, new Object[0]);
        if (iRet != 1) {
            return false;
        }
        return ack[0] == 5;
    }

    private byte[] receiveReply() {
        byte[] buffer = new byte[32];
        int iRet = this.uartDevice.read(buffer, 0, 1, 5000);
        if (iRet != 1) {
            logger.debug("/// receiveReply | read1 | iRet = " + iRet, new Object[0]);
            this.sendReply((byte)21);
            return null;
        }
        logger.debug("/// receiveReply | read1 | buffer = " + BytesUtil.bytes2HexString(buffer), new Object[0]);
        if (buffer[0] != 2) {
            this.sendReply((byte)21);
            return null;
        }
        iRet = this.uartDevice.read(buffer, 1, 2, 5000);
        if (iRet != 2) {
            logger.debug("/// receiveReply | read2 | iRet = " + iRet, new Object[0]);
            this.sendReply((byte)21);
            return null;
        }
        logger.debug("/// receiveReply | read2 | buffer = " + BytesUtil.bytes2HexString(buffer), new Object[0]);
        short dataLen = (short)((buffer[1] | buffer[2] << 8 & 0xFF00) & 0xFFFF);
        byte[] dataBuff = new byte[dataLen + 3];
        iRet = this.uartDevice.read(dataBuff, 5000);
        if (iRet != dataBuff.length) {
            logger.debug("/// receiveReply | read3 | iRet = " + iRet, new Object[0]);
            this.sendReply((byte)21);
            return null;
        }
        logger.debug("/// receiveReply | read | dataLen = " + dataLen + ", dataBuff = " + BytesUtil.bytes2HexString(dataBuff), new Object[0]);
        short recvSum = (short)(dataBuff[dataLen] & 0xFF | dataBuff[dataLen + 1] << 8 & 0xFF00);
        short checkSum = BRScanner.calcCheckSum(Arrays.copyOf(dataBuff, (int)dataLen));
        if (recvSum != checkSum) {
            logger.debug("/// receiveReply | checkSum | recvSum = " + recvSum + ", checkSum = " + checkSum, new Object[0]);
            this.sendReply((byte)21);
            return null;
        }
        if (dataBuff[dataBuff.length - 1] != 3) {
            this.sendReply((byte)21);
            return null;
        }
        this.sendReply((byte)5);
        return Arrays.copyOf(dataBuff, (int)dataLen);
    }

    private boolean sendReply(byte answer) {
        int iRet = this.uartDevice.write(new byte[]{answer}, 5000);
        logger.debug("/// sendReply | write | iRet = " + iRet, new Object[0]);
        return iRet != -1;
    }

    private boolean sendDecodeReply() {
        int iRet = this.uartDevice.write(BytesUtil.hexString2Bytes(ACK_DECODE_DATA), 5000);
        logger.debug("/// sendDecodeReply | write | iRet = " + iRet, new Object[0]);
        return iRet != -1;
    }

    private static byte[] makeCommand(byte[] insData) {
        int offset = 0;
        int dataLen = insData.length;
        byte[] cmd = new byte[6 + dataLen];
        cmd[offset++] = 2;
        cmd[offset++] = (byte)(dataLen & 0xFF);
        cmd[offset++] = (byte)(dataLen >> 8 & 0xFF);
        System.arraycopy(insData, 0, cmd, offset, dataLen);
        offset += dataLen;
        short checkSum = BRScanner.calcCheckSum(insData);
        cmd[offset++] = (byte)(checkSum & 0xFF);
        cmd[offset++] = (byte)(checkSum >> 8 & 0xFF);
        cmd[offset] = 3;
        logger.debug("/// makeCommand | cmd = " + BytesUtil.bytes2HexString(cmd), new Object[0]);
        return cmd;
    }

    private static boolean isDecodeFrame(byte[] data) {
        if (data == null || data.length < 11) {
            return false;
        }
        return data[0] == -1 && data[1] == -12 && data[4] == -12 && data[5] == 0 && data[6] == 0 && data[7] == 0 && data[data.length - 1] == 3;
    }

    static short calculateDecodeCheckSum(byte[] data) {
        int checkSum = 0;
        int length = data[0] << 8 & 0xFF00 | data[1] & 0xFF;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            checkSum = i == 0 ? (int)((short)(checkSum + 255)) : (i == 1 ? (int)((short)(checkSum + 244)) : (int)((short)(checkSum + data[j++])));
        }
        return (short)(~checkSum + 1);
    }

    private byte[] parseDecodeData(byte[] data) {
        int length = data[2] << 8 & 0xFF00 | data[3] & 0xFF;
        byte[] checkData = Arrays.copyOfRange(data, 2, data.length - 2);
        byte[] codeData = Arrays.copyOfRange(data, 8, 8 + length);
        short checkSum = (short)(data[data.length - 3] + (data[data.length - 2] << 8));
        short checkValue = BRScanner.calculateDecodeCheckSum(checkData);
        return codeData;
    }

    static short calcCheckSum(byte[] data) {
        short sum = 0;
        for (byte b : data) {
            sum = (short)(sum + b);
        }
        return sum;
    }

    private void startListen() {
        this.stopListen();
        this.listenThread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.debug("----------- listenThread started --------------", new Object[0]);
                if (!BRScanner.this.openDevice()) {
                    BRScanner.this.isStarted = false;
                    return;
                }
                logger.debug("----------- listenThread running --------------", new Object[0]);
                while (!BRScanner.this.listenThread.isInterrupted()) {
                    if (!BRScanner.this.isDataReceived()) continue;
                    byte[] recvData = BRScanner.this.receiveData();
                    if (recvData == null) {
                        BRScanner.this.notifyResult(1, new byte[0]);
                        continue;
                    }
                    logger.debug("/// listenThread | recvData = " + BytesUtil.bytes2HexString(recvData), new Object[0]);
                    if (!BRScanner.isDecodeFrame(recvData)) {
                        BRScanner.this.notifyResult(0, recvData);
                        continue;
                    }
                    BRScanner.this.sendDecodeReply();
                    byte[] codeData = BRScanner.this.parseDecodeData(recvData);
                    logger.debug("/// listenThread | codeData = " + BytesUtil.bytes2HexString(codeData), new Object[0]);
                    BRScanner.this.notifyResult(0, codeData);
                }
                logger.debug("----------- listenThread exit!!! --------------", new Object[0]);
                BRScanner.this.closeDevice();
                BRScanner.this.isStarted = false;
            }
        });
        this.listenThread.start();
        this.isStarted = true;
    }

    private void stopListen() {
        if (this.listenThread != null) {
            if (this.listenThread.isAlive()) {
                this.listenThread.interrupt();
                try {
                    this.listenThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.listenThread = null;
        }
    }

    private void notifyResult(int error, byte[] result) {
        if (this.onScanListener != null) {
            Parcel data = Parcel.obtain();
            data.writeInt(error);
            data.writeByteArray(result);
            data.setDataPosition(0);
            this.onScanListener.notifyData(data);
        }
    }

    public static abstract class OnScanListener
    extends RemoteListener {
        public static final int ERROR_NONE = 0;
        public static final int ERROR_TIMEOUT = 1;
        public static final int ERROR_FAIL = 2;

        public OnScanListener() {
        }

        public OnScanListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        public final int getEventId() {
            return 0;
        }

        @Override
        protected final void onListened(Parcel data) {
            int ret = data.readInt();
            byte[] code = data.createByteArray();
            if (ret == 0) {
                this.onScanSuccess(code);
            } else {
                this.onScanFail(ret);
            }
        }

        public abstract void onScanSuccess(byte[] var1);

        public abstract void onScanFail(int var1);
    }
}

