/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.CpuCardDriver;
import com.landicorp.android.eptapi.card.InsertCardDriver;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.card.data.ApduComm;
import com.landicorp.android.eptapi.card.data.ApduResp;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class InsertCpuCardDriver
extends CpuCardDriver<OnExchangeListener>
implements InsertDriver {
    public static final int VOL_3 = 1;
    public static final int VOL_5 = 2;
    public static final int VOL_18 = 3;
    public static final int VOL_DEFAULT = 2;
    public static final int MODE_EMV = 1;
    public static final int MODE_BPS_576 = 2;
    public static final int MODE_BPS_384 = 3;
    public static final int MODE_BPS_192 = 4;
    public static final int MODE_SHB = 5;
    public static final int MODE_ISO = 6;
    public static final int MODE_TCR = 7;
    public static final int MODE_DEFAULT = 1;
    private String deviceName = null;
    private InsertCardDriver mCardDriver = null;
    private int mOnExchangeApduExtendID = 0;

    public InsertCpuCardDriver() {
        this("USERCARD");
    }

    public InsertCpuCardDriver(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public InsertCpuCardDriver(String packageName, String deviceName) {
        super(packageName, 775, 777, deviceName);
        this.deviceName = deviceName;
        this.mCardDriver = new InsertCardDriver(packageName, deviceName, 773, 776, 774);
    }

    public void setPowerupVoltage(int vol) {
        this.mCardDriver.setPowerupVoltage(vol);
    }

    public void setPowerupMode(int mode) {
        this.mCardDriver.setPowerupMode(mode);
    }

    public void powerup(OnPowerupListener listener) throws RequestException {
        this.mCardDriver.powerup(listener);
    }

    public int powerup(BytesBuffer atr, IntegerBuffer protocol) throws RequestException {
        return this.mCardDriver.powerup(atr, protocol);
    }

    public boolean powerdown() throws RequestException {
        return this.mCardDriver.powerdown() == 0;
    }

    public int powerDown() throws RequestException {
        return this.mCardDriver.powerdown();
    }

    @Override
    public void exchangeApdu(byte[] data, OnExchangeListener listener) throws RequestException {
        listener.setPortName(this.deviceName);
        super.exchangeApdu(data, listener);
    }

    public int incomingApdu(ApduComm cmd, byte[] in, ApduResp response) throws RequestException {
        return this.mCardDriver.incomingApdu(cmd, in, response);
    }

    public int outgoingApdu(ApduComm cmd, ApduResp response, BytesBuffer out) throws RequestException {
        return this.mCardDriver.outgoingApdu(cmd, response, out);
    }

    public int exchangeSAMCmd(byte[] data, BytesBuffer response) throws RequestException {
        return this.mCardDriver.exchangeSAMCmd(data, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int exchangeApduExtend(byte[] apdu, BytesBuffer responseApdu) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeByteArray(apdu);
            MasterController.getInstance().request(this.packageName, 782, data, reply);
            int ret = reply.readInt();
            responseApdu.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exchangeApduExtend(byte[] apdu, OnExchangeListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnExchangeApduExtendID)) {
            logger.error("### exchangeApduExtend has not finished! ###", new Object[0]);
            listener.onFail(143);
            return;
        }
        listener.setDriver(this);
        listener.setPortName(this.deviceName);
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeByteArray(apdu);
            this.mOnExchangeApduExtendID = ServiceVariable.saveListener(this.packageName, listener);
            MasterController.getInstance().requestCallback(this.packageName, 781, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public boolean exists() throws RequestException {
        return this.mCardDriver.exists();
    }

    @Override
    public void halt() throws RequestException {
        this.stopListenExchange();
        this.mCardDriver.halt();
    }

    @Override
    public String getDriverName() {
        return "INSERT_CPU";
    }

    protected void stopListenPowerup() {
        this.mCardDriver.stopListenPowerup();
    }

    @Override
    public String getDeviceName() {
        return this.mCardDriver.getDeviceName();
    }

    public static abstract class OnExchangeListener
    extends CpuCardDriver.OnExchangeListener {
        public static final int ERROR_DATAERR = 226;
        public static final int ERROR_NOPOWER = 227;
        public static final int ERROR_NOCARD = 251;
        public static final int ERROR_FORRESP = 230;
        public static final int ERROR_SWDIFF = 231;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_ERRTYPE = 194;
        public static final int ERROR_TIMEOUT = 138;

        @Override
        public final int getEventId() {
            return 1026;
        }

        @Override
        public boolean checkResult(int result) {
            return result == 0 || result == 231;
        }

        @Override
        public abstract void onFail(int var1);

        @Override
        public abstract void onSuccess(byte[] var1);
    }

    public static abstract class OnPowerupListener
    extends InsertCardDriver.OnPowerupListener {
        public static final int ERROR_NOPOWER = 227;
        public static final int ERROR_ATRERR = 162;
        public static final int ERROR_ATRERR_S = 178;
        public static final int ERROR_NOCARD = 251;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_ERRTYPE = 194;
        public static final int ERROR_TIMEOUT = 138;

        public OnPowerupListener() {
        }

        public OnPowerupListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        protected final void onPowerup(Parcel data) {
            int ret = data.readInt();
            if (ret == 0) {
                this.onPowerup(data.readInt(), data.createByteArray());
            } else {
                this.onFail(ret);
            }
        }

        @Override
        public final int getEventId() {
            return 1027;
        }

        public abstract void onPowerup(int var1, byte[] var2);

        public abstract void onFail(int var1);
    }
}

