/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.card.data.ApduComm;
import com.landicorp.android.eptapi.card.data.ApduResp;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class InsertCardDriver
implements InsertDriver {
    static final Logger logger = Logger.getLogger(InsertCardDriver.class);
    public static final int VOL_3 = 1;
    public static final int VOL_5 = 2;
    public static final int VOL_18 = 3;
    public static final int VOL_DEFAULT = 2;
    public static final int MODE_EMV = 1;
    public static final int MODE_BPS_576 = 2;
    public static final int MODE_BPS_384 = 3;
    public static final int MODE_BPS_192 = 4;
    public static final int MODE_SHB = 5;
    public static final int MODE_ISO = 6;
    public static final int MODE_TCR = 7;
    public static final int MODE_DEFAULT = 1;
    private int mPowerupListenerID = 0;
    private int mPowerUpCode = 0;
    private int mPowerUpSyncCode = 0;
    private int mPowerDownCode = 0;
    private int mPowerupVoltage = 0;
    private int mPowerupMode = 0;
    private String deviceName;
    private String packageName;

    public InsertCardDriver(String deviceName, int powerupcode, int powerupSyncCode, int powerdowncode) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName, powerupcode, powerupSyncCode, powerdowncode);
    }

    public InsertCardDriver(String packageName, String deviceName, int powerupcode, int powerupSyncCode, int powerdowncode) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.mPowerUpCode = powerupcode;
        this.mPowerDownCode = powerdowncode;
        this.mPowerUpSyncCode = powerupSyncCode;
        this.mPowerupVoltage = 2;
        this.mPowerupMode = 1;
        this.deviceName = deviceName;
        this.packageName = packageName;
    }

    public void setPowerupVoltage(int vol) {
        InsertCardDriver.checkPowerVoltage(vol);
        this.mPowerupVoltage = vol;
    }

    private static void checkPowerVoltage(int vol) {
        if (vol < 1 || vol > 3) {
            throw new IllegalArgumentException(String.format("Invalid power voltage: 0x%x", vol));
        }
    }

    public void setPowerupMode(int mode) {
        InsertCardDriver.checkPowerMode(mode);
        this.mPowerupMode = mode;
    }

    private static void checkPowerMode(int mode) {
        if (mode < 1 || mode > 7) {
            throw new IllegalArgumentException(String.format("Invalid power mode: 0x%x", mode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerup(BytesBuffer atr, IntegerBuffer protocol) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(this.deviceName.getBytes());
            data.writeInt(this.mPowerupMode);
            data.writeInt(this.mPowerupVoltage);
            MasterController.getInstance().request(this.packageName, this.mPowerUpSyncCode, data, reply);
            int ret = reply.readInt();
            if (ret == 0) {
                protocol.setData(reply.readInt());
                atr.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void powerup(OnPowerupListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mPowerupListenerID)) {
            logger.error("### powerup has not finished! ###", new Object[0]);
            return;
        }
        OnPowerupListener onPowerupListener = listener;
        synchronized (onPowerupListener) {
            if (listener.isStarted() && listener.getDriver() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two drivers!");
            }
            listener.setDriver(this);
            listener.setStarted(true);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(this.deviceName.getBytes());
        data.writeInt(this.mPowerupMode);
        data.writeInt(this.mPowerupVoltage);
        try {
            this.mPowerupListenerID = ServiceVariable.saveListener(this.packageName, listener);
            MasterController.getInstance().requestCallback(this.packageName, this.mPowerUpCode, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerdown() throws RequestException {
        Parcel data = Parcel.obtain();
        data.writeByteArray(this.deviceName.getBytes());
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, this.mPowerDownCode, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel data = Parcel.obtain();
        data.writeByteArray(this.deviceName.getBytes());
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void halt() throws RequestException {
        this.stopListenPowerup();
        Parcel data = Parcel.obtain();
        data.writeByteArray(this.deviceName.getBytes());
        try {
            MasterController.getInstance().request(this.packageName, 772, data);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "INSERT_CARD";
    }

    protected synchronized void stopListenPowerup() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mPowerupListenerID);
        if (l == null) {
            return;
        }
        MasterController.getInstance().uninstallListener(this.packageName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incomingApdu(ApduComm cmd, byte[] in, ApduResp response) throws RequestException {
        Precondition.checkNotNull(cmd);
        Precondition.checkNotNull(response);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(this.deviceName.getBytes());
            data.writeByteArray(cmd.toBinary());
            data.writeByteArray(in);
            MasterController.getInstance().request(this.packageName, 778, data, reply);
            int ret = reply.readInt();
            int dataLen = reply.dataAvail();
            if (dataLen > 0) {
                byte[] respData = reply.createByteArray();
                response.fromBinary(respData);
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outgoingApdu(ApduComm cmd, ApduResp response, BytesBuffer out) throws RequestException {
        Precondition.checkNotNull(cmd);
        Precondition.checkNotNull(response);
        Precondition.checkNotNull(out);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(this.deviceName.getBytes());
            data.writeByteArray(cmd.toBinary());
            MasterController.getInstance().request(this.packageName, 779, data, reply);
            int ret = reply.readInt();
            if (reply.dataAvail() > 0) {
                byte[] respData = reply.createByteArray();
                response.fromBinary(respData);
            }
            if (reply.dataAvail() > 0) {
                out.setData(reply.createByteArray());
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exchangeSAMCmd(byte[] data, BytesBuffer response) throws RequestException {
        Parcel request = Parcel.obtain();
        Parcel resp = Parcel.obtain();
        request.writeByteArray(StringUtil.getGBK(this.deviceName));
        request.writeByteArray(data);
        try {
            MasterController.getInstance().request(this.packageName, 780, request, resp);
            int ret = resp.readInt();
            response.setData(resp.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            request.recycle();
            resp.recycle();
        }
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    static abstract class OnPowerupListener
    extends RemoteListener {
        private boolean started;
        InsertCardDriver mDriver = null;

        public OnPowerupListener() {
        }

        public void setStarted(boolean b) {
            this.started = b;
        }

        public boolean isStarted() {
            return this.started;
        }

        public InsertCardDriver getDriver() {
            return this.mDriver;
        }

        public OnPowerupListener(PausableHandler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void onListened(Parcel data) {
            InsertCardDriver driver = this.mDriver;
            if (driver == null) {
                return;
            }
            String deviceName = data.readString();
            if (deviceName.equals(driver.deviceName)) {
                OnPowerupListener onPowerupListener = this;
                synchronized (onPowerupListener) {
                    this.setStarted(false);
                }
                driver.stopListenPowerup();
                this.onPowerup(data);
            }
        }

        protected final void setDriver(InsertCardDriver driver) {
            this.mDriver = driver;
        }

        protected abstract void onPowerup(Parcel var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnPowerupListener onPowerupListener = this;
            synchronized (onPowerupListener) {
                this.setStarted(false);
            }
        }
    }
}

