/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.card.CpuCardInterface;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public abstract class CpuCardDriver<T extends OnExchangeListener>
implements CpuCardInterface<T> {
    static final Logger logger = Logger.getLogger(CpuCardDriver.class);
    private static final int ERROR_FAIL = 1;
    private int mExchangeCode = 0;
    private int mExchangeSyncCode = 0;
    private String mPort = null;
    private int mOnExchangeListenerID = 0;
    protected String packageName;

    protected CpuCardDriver(int exchangeCode, int exchangeSyncCode, String port) {
        this(MasterController.getInstance().getDefaultAppName(), exchangeCode, exchangeSyncCode, port);
    }

    protected CpuCardDriver(String clientPkgName, int exchangeCode, int exchangeSyncCode, String port) {
        Precondition.checkNotEmpty(clientPkgName);
        Precondition.checkNotEmpty(port);
        this.mExchangeCode = exchangeCode;
        this.mExchangeSyncCode = exchangeSyncCode;
        this.mPort = port;
        this.packageName = clientPkgName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int exchangeApdu(byte[] apdu, BytesBuffer responseApdu) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel resp = Parcel.obtain();
        p.writeByteArray(StringUtil.getGBK(this.mPort));
        p.writeByteArray(apdu);
        try {
            MasterController.getInstance().request(this.packageName, this.mExchangeSyncCode, p, resp);
            int ret = resp.readInt();
            responseApdu.setData(resp.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            p.recycle();
            resp.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void exchangeApdu(byte[] data, T listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnExchangeListenerID)) {
            logger.error("### exchangeApdu has not finished! ###", new Object[0]);
            ((OnExchangeListener)listener).onFail(1);
            return;
        }
        ((OnExchangeListener)listener).setDriver(this);
        ((OnExchangeListener)listener).setPortName(this.mPort);
        Parcel p = Parcel.obtain();
        p.writeByteArray(StringUtil.getGBK(this.mPort));
        p.writeByteArray(data);
        try {
            this.mOnExchangeListenerID = ServiceVariable.saveListener(this.packageName, listener);
            MasterController.getInstance().requestCallback(this.packageName, this.mExchangeCode, p, (RemoteListener)listener);
        }
        finally {
            p.recycle();
        }
    }

    protected synchronized void stopListenExchange() {
        Integer l = ServiceVariable.removeListener(this.packageName, this.mOnExchangeListenerID);
        if (null == l) {
            return;
        }
        MasterController.getInstance().uninstallListener(this.packageName, l);
    }

    static abstract class OnExchangeListener
    extends CpuCardInterface.OnExchangeListener {
        private CpuCardDriver<? extends OnExchangeListener> mDriver;
        private String mPortName = null;

        OnExchangeListener() {
        }

        @Override
        protected final void onListened(Parcel data) {
            if (this.mDriver == null) {
                return;
            }
            this.mDriver.stopListenExchange();
            this.onResponse(data);
        }

        protected void setDriver(CpuCardDriver<? extends OnExchangeListener> d) {
            this.mDriver = d;
        }

        protected final void onResponse(Parcel data) {
            String portName = data.readString();
            if (TextUtils.isEmpty((CharSequence)portName) || !portName.equals(this.mPortName)) {
                return;
            }
            int errCode = data.readInt();
            if (this.checkResult(errCode)) {
                this.onSuccess(data.createByteArray());
            } else {
                this.onFail(errCode);
            }
        }

        protected final void setPortName(String port) {
            this.mPortName = port;
        }

        protected boolean checkResult(int result) {
            return result == 0;
        }

        protected abstract void onSuccess(byte[] var1);

        protected abstract void onFail(int var1);
    }
}

