/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.algorithm;

import com.landicorp.android.eptapi.algorithm.RSAPublicKey;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.Arrays;

public class RSAPrivateKey {
    int bits;
    byte[] modulus = new byte[256];
    byte[] pubExp = new byte[256];
    byte[] exponent = new byte[256];
    byte[][] prime = new byte[2][128];
    byte[][] prmExp = new byte[2][128];
    byte[] coefficient = new byte[128];

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getModulus() {
        return this.modulus;
    }

    public void setModulus(byte[] modulus) {
        Precondition.checkNotNull(modulus);
        Arrays.fill(this.modulus, (byte)0);
        int length = Math.min(256, modulus.length);
        int offset = 256 - length;
        System.arraycopy(modulus, 0, this.modulus, offset, length);
    }

    public byte[] getPublicExponent() {
        return this.pubExp;
    }

    public void setPublicExponent(byte[] exponent) {
        Precondition.checkNotNull(exponent);
        Arrays.fill(this.pubExp, (byte)0);
        int length = Math.min(256, exponent.length);
        int offset = 256 - length;
        System.arraycopy(exponent, 0, this.pubExp, offset, length);
    }

    public byte[] getExponent() {
        return this.exponent;
    }

    public void setExponent(byte[] exponent) {
        Precondition.checkNotNull(exponent);
        Arrays.fill(this.exponent, (byte)0);
        int length = Math.min(256, exponent.length);
        int offset = 256 - length;
        System.arraycopy(exponent, 0, this.exponent, offset, length);
    }

    public byte[][] getPrime() {
        return this.prime;
    }

    public void setPrime(byte[][] prime) {
        Precondition.checkNotNullEmpty(prime);
        for (int i = 0; i < this.prime.length && i < prime.length; ++i) {
            if (prime[i] == null || prime[i].length <= 0) continue;
            Arrays.fill(this.prime[i], (byte)0);
            int length = Math.min(128, prime[i].length);
            int offset = 128 - length;
            System.arraycopy(prime[i], 0, this.prime[i], offset, length);
        }
    }

    public byte[][] getPrimeExponent() {
        return this.prmExp;
    }

    public void setPrimeExponent(byte[][] exponent) {
        Precondition.checkNotNullEmpty(exponent);
        for (int i = 0; i < this.prmExp.length && i < exponent.length; ++i) {
            if (exponent[i] == null || exponent[i].length <= 0) continue;
            Arrays.fill(this.prmExp[i], (byte)0);
            int length = Math.min(128, exponent[i].length);
            int offset = 128 - length;
            System.arraycopy(exponent[i], 0, this.prmExp[i], offset, length);
        }
    }

    public byte[] getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(byte[] coefficient) {
        Precondition.checkNotNull(coefficient);
        Arrays.fill(this.coefficient, (byte)0);
        int length = Math.min(128, coefficient.length);
        int offset = 128 - length;
        System.arraycopy(coefficient, 0, this.coefficient, offset, length);
    }

    public RSAPublicKey obtainPublicKey() {
        RSAPublicKey pubKey = new RSAPublicKey();
        pubKey.bits = this.bits;
        int modLen = Math.min(this.modulus.length, 256);
        System.arraycopy(this.modulus, 0, pubKey.modulus, 0, modLen);
        int expLen = Math.min(this.pubExp.length, 256);
        System.arraycopy(this.pubExp, 0, pubKey.exponent, 0, expLen);
        return pubKey;
    }
}

