package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.resource.mapper.ReportMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 报表控制器（兼容）
 *
 * @author Mr.river
 * @apiNote 该api实现的功能将在后期使用其他框架代替，仅用于保持对v3及以前版本的兼容
 */
@Deprecated(since = "1.0.0")
@RestController
@RequestMapping("/report")
public class ReportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportController.class);
    private final LogicController logicController;
    private final ReportMapper reportMapper;

    public ReportController(LogicController logicController, ReportMapper reportMapper) {
        this.logicController = logicController;
        this.reportMapper = reportMapper;
    }

    /**
     * 执行报表
     *
     * @param reportName 报表名称
     * @param values     查询参数
     * @param response   response
     * @param request    request
     * @return 执行结果
     */
    @PostMapping(value = "{reportName}", produces = MediaType.APPLICATION_JSON_VALUE)
    public Object run(@PathVariable("reportName") String reportName,
                      @RequestBody(required = false) String values,
                      HttpServletResponse response,
                      HttpServletRequest request) {
        JSONObject params = new JSONObject();
        params.put("reportName", reportName);
        JSONObject valuesJson = values != null ? new JSONObject(values) : null;
        if (valuesJson != null && valuesJson.has("data")) {
            valuesJson = valuesJson.getJSONObject("data");
        }
        params.put("values", valuesJson);
        return DynamicDataSource.withDataSource(reportMapper.getResource(reportName).getDataSource(),
                () -> logicController.runByNoToken("runReportForV4Compatible", params.toString(), response, request));
    }
}
