/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.plugin;

import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.v3.workflow.controller.Server;
import com.af.v4.v3.workflow.perform.ActivityDef;
import com.af.v4.v3.workflow.perform.DiversionDef;
import com.af.v4.v3.workflow.perform.ProcessDef;
import com.af.v4.v3.workflow.perform.ProcessInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowLogicServer {
    private final SqlService sqlService;
    private final SessionPool sessionPool;
    private final Server server;

    public WorkFlowLogicServer(SqlService sqlService, SessionPool sessionPool, Server server) {
        this.sqlService = sqlService;
        this.sessionPool = sessionPool;
        this.server = server;
    }

    public static boolean isRepeat(JSONArray jsonArray, JSONObject object) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!object.get("id").toString().equals(jsonArray.getJSONObject(i).get("id").toString())) continue;
            return false;
        }
        return true;
    }

    public String startWorkFlow(String name, String username, String userid, JSONObject personExpression) {
        JSONArray arr = new JSONArray();
        String personExpressionArr = arr.put((Object)personExpression).toString();
        return this.server.txStartProcess(name, username, userid, personExpressionArr);
    }

    public String startWorkflow(String name) {
        return this.server.txstartProcess(name);
    }

    public String startActivity(String processid, String name) {
        return this.server.txstartActivity(processid, name);
    }

    public int startActivity(String processid, String name, String username, String userid) {
        return this.server.txstartActivity(processid, name, username, userid);
    }

    public int startActivity(String processid, String name, JSONObject vars, String username, String userid) {
        return this.server.txstartActivity(processid, name, vars.toString(), username, userid);
    }

    public void setVars(String processid, String vars) {
        this.server.ttxsetVars(processid, vars);
    }

    public void setVars(String processid, String vars, String username, String userid) {
        this.server.txsetVars(processid, vars, username, userid);
    }

    public void setVars(String processid, JSONObject json) {
        this.server.ttxsetVars(processid, json.toString());
    }

    public JSONObject setVars(String processid, JSONObject json, String username, String userid) {
        return this.server.ttxsetVars(processid, json.toString(), username, userid);
    }

    public JSONObject setVars(String defid, String processid, JSONObject json, String username, String userid) {
        return this.server.ttxsetVars(defid, processid, json.toString(), username, userid);
    }

    public JSONObject setVars(int actid, String processid, JSONObject json, String username, String userid) {
        return this.server.ttxsetVars(actid, processid, json.toString(), username, userid);
    }

    public String getAction(String activityId) {
        return this.server.txgetAction(activityId);
    }

    public String getWait(String processid) {
        return this.server.txgetWait(processid);
    }

    public String getWFGraph(String processid) {
        return this.server.txgetWFGraph(processid);
    }

    public JSONObject getWFGraph(String processid, Integer width, Integer levelHeight, String nodeType, String edgeType) throws Exception {
        Session session = this.sessionPool.getSession();
        ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Object)processid);
        ProcessDef pdef = procIns.getDefine();
        ActivityDef act = pdef.getStartActivity();
        HashMap<Integer, ArrayList<String>> levelCount = new HashMap<Integer, ArrayList<String>>();
        this.getLevelCount(act, 1, levelCount);
        JSONArray nodes = new JSONArray();
        JSONArray edges = new JSONArray();
        JSONObject res = this.getNodes(nodes, edges, processid, act, width, levelHeight, nodeType, edgeType, 1, levelCount);
        return res;
    }

    public JSONObject getNodes(JSONArray nodes, JSONArray edges, String processid, ActivityDef act, int width, Integer levelHeight, String nodeType, String edgeType, Integer level, Map<Integer, ArrayList<String>> map) throws Exception {
        ArrayList<String> list = map.get(level);
        int levelCount = list.size();
        int index = list.indexOf(act.getID()) + 1;
        JSONObject node = new JSONObject();
        node.put("id", (Object)act.getID());
        node.put("type", (Object)nodeType);
        node.put("text", (Object)act.getName());
        node.put("x", width * (2 * index - 1) / (2 * levelCount));
        node.put("y", levelHeight * level);
        JSONArray jsonArray = this.sqlService.querySQL("workflowSelectActivityins", "select * from activityins where processid = '" + processid + "' and defid = '" + act.getID() + "' order by id desc");
        node.put("properties", (Object)jsonArray);
        if (WorkFlowLogicServer.isRepeat(nodes, node)) {
            nodes.put((Object)node);
        }
        for (int i = 0; i < act.getSplits().size(); ++i) {
            JSONObject edge = new JSONObject();
            DiversionDef divDef = act.getSplits().get(i);
            ActivityDef tailDef = divDef.getTail();
            edge.put("id", (Object)divDef.getID());
            edge.put("type", (Object)edgeType);
            edge.put("sourceNodeId", (Object)act.getID());
            edge.put("targetNodeId", (Object)tailDef.getID());
            if (WorkFlowLogicServer.isRepeat(edges, edge)) {
                edges.put((Object)edge);
            }
            this.getNodes(nodes, edges, processid, tailDef, width, levelHeight, nodeType, edgeType, level + 1, map);
        }
        JSONObject obj = new JSONObject();
        obj.put("edges", (Object)edges);
        obj.put("nodes", (Object)nodes);
        return obj;
    }

    public Map<Integer, ArrayList<String>> getLevelCount(ActivityDef act, Integer level, Map<Integer, ArrayList<String>> map) {
        if (map.containsKey(level)) {
            list = map.get(level);
            if (!list.contains(act.getID())) {
                list.add(act.getID());
                map.put(level, list);
            }
        } else {
            list = new ArrayList();
            list.add(act.getID());
            map.put(level, list);
        }
        for (int i = 0; i < act.getSplits().size(); ++i) {
            DiversionDef divDef = act.getSplits().get(i);
            ActivityDef tailDef = divDef.getTail();
            this.getLevelCount(tailDef, level + 1, map);
        }
        return map;
    }

    public String excuteWorkFlow(String acitityid, String username, String userid, JSONObject personExpression) {
        JSONArray arr = new JSONArray();
        String personExpressionArr = arr.put((Object)personExpression).toString();
        return this.server.txperformActivity(acitityid, username, userid, personExpressionArr);
    }

    public String stopWorkFlow(String acitityid) {
        return this.server.txStopProcess(acitityid);
    }

    public String getOperator(String actorexpression) {
        if (actorexpression.contains("userid")) {
            String sub = actorexpression.substring(actorexpression.indexOf("userid"));
            return sub.substring(sub.indexOf("'") + 1, sub.lastIndexOf("'"));
        }
        if (actorexpression.contains("(") && actorexpression.length() > 3) {
            return actorexpression.substring(actorexpression.indexOf("(") + 1, actorexpression.indexOf(")"));
        }
        return "";
    }
}

