/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.v3.workflow.perform.Diagram;
import com.af.v4.v3.workflow.perform.DiagramManager;
import com.af.v4.v3.workflow.perform.ProcessDef;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ProcessDefManager
implements Serializable {
    private static final long serialVersionUID = 7046680794343910842L;
    private final Map<String, ProcessDef> nameAndProcesses = new ConcurrentHashMap<String, ProcessDef>();

    public static ProcessDefManager getInstance() {
        return (ProcessDefManager)SpringUtils.getBean(ProcessDefManager.class);
    }

    private static ProcessDef getProcessesByUser(String name) {
        try {
            Diagram diagram = DiagramManager.getInstance().getUserDiagramByName(name);
            if (diagram == null) {
                return null;
            }
            return new ProcessDef(diagram);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void load() {
        Collection<Diagram> v;
        DiagramManager manager = DiagramManager.getInstance();
        try {
            v = manager.getDiagrams();
        }
        catch (Exception e) {
            throw new RuntimeException("ProcessDefManager.load()\u51fa\u9519\uff0c\u88c5\u8f7d\u6d41\u7a0b\u56fe\u5b9a\u4e49\u51fa\u9519");
        }
        for (Diagram diagram : v) {
            try {
                this.nameAndProcesses.put(diagram.getName(), new ProcessDef(diagram));
            }
            catch (Exception e) {
                throw new RuntimeException("ProcessDefManager.load()\u51fa\u9519\uff0c\u4ea7\u751f\u6d41\u7a0b\u5b9a\u4e49\u51fa\u9519");
            }
        }
    }

    public void reLoadProcessDefByName(Diagram d) {
        ProcessDef def = this.getProcessDef(d.getName());
        if (def != null) {
            def.setDiagram(d);
        } else {
            def = new ProcessDef(d);
        }
        this.nameAndProcesses.put(d.getName(), def);
    }

    public ProcessDef getProcessDef(String name) {
        ProcessDef result = ProcessDefManager.getProcessesByUser(name);
        if (result != null) {
            return result;
        }
        return this.nameAndProcesses.get(name);
    }

    public Collection<ProcessDef> getProcesses() {
        return this.nameAndProcesses.values();
    }

    public Iterator<ProcessDef> getProcessesIterator() {
        return this.nameAndProcesses.values().iterator();
    }
}

