/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.application.service.GlazeApplicationService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.v3.workflow.perform.Diagram;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DiagramManager
implements Serializable {
    private static final long serialVersionUID = 373843474314241569L;
    private static final Logger log = LoggerFactory.getLogger(DiagramManager.class);
    private final Map<String, Diagram> nameAndDiagrams = new ConcurrentHashMap<String, Diagram>();
    private final GlazeApplicationService applicationService;
    private final LiuLiConfigService liuliConfigService;

    public DiagramManager(GlazeApplicationService applicationService, LiuLiConfigService liuliConfigService) {
        this.applicationService = applicationService;
        this.liuliConfigService = liuliConfigService;
        this.load();
    }

    public static DiagramManager getInstance() {
        return (DiagramManager)SpringUtils.getBean(DiagramManager.class);
    }

    private Diagram getDiagram(String name) {
        JSONObject result = this.liuliConfigService.get(name);
        if (result == null) {
            return null;
        }
        Diagram diagram = new Diagram();
        diagram.setName(name);
        diagram.setContext(result.get("source").toString());
        return diagram;
    }

    public void load() {
        URL url = this.getClass().getClassLoader().getResource("processes/");
        if (url == null) {
            return;
        }
        log.info("========>\u8def\u5f84>{}", (Object)url);
        String path = url.getPath();
        File[] files = new File(path).listFiles();
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                try {
                    String lineTxt;
                    String digName = fileName.substring(0, fileName.indexOf("."));
                    Diagram diagram = new Diagram();
                    diagram.setName(digName);
                    this.nameAndDiagrams.put(digName, diagram);
                    StringBuilder result = new StringBuilder();
                    String encoding = "UTF-8";
                    InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
                    BufferedReader bufferedReader = new BufferedReader(read);
                    while ((lineTxt = bufferedReader.readLine()) != null) {
                        result.append(lineTxt);
                    }
                    int index = result.indexOf("<");
                    if (index != -1) {
                        result = new StringBuilder(result.substring(index));
                    }
                    bufferedReader.close();
                    diagram.setContext(result.toString());
                }
                catch (Exception e) {
                    log.error("\u6d41\u7a0b{}: {}", (Object)fileName, (Object)e.getMessage());
                }
            }
        }
    }

    public void load(String loadPath) {
        if (loadPath == null || loadPath.isEmpty()) {
            return;
        }
        File files = new File(loadPath);
        if (!files.isFile()) {
            return;
        }
        String fileName = files.getName();
        try {
            String digName = fileName.substring(0, fileName.indexOf("."));
            Diagram diagram = new Diagram();
            diagram.setName(digName);
            this.nameAndDiagrams.put(digName, diagram);
            StringBuilder result = new StringBuilder();
            String encoding = "UTF-8";
            try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(files), encoding);
                 BufferedReader bufferedReader = new BufferedReader(read);){
                String lineTxt;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    result.append(lineTxt);
                }
                diagram.setContext(result.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b{}: {}", (Object)fileName, (Object)e.getMessage());
        }
    }

    public Diagram userLoad(String name) {
        try {
            return this.getDiagram(name);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b" + name + ": " + e.getMessage(), e);
        }
    }

    private List<String> loadResources(URL url, String path) {
        ArrayList<String> strs = new ArrayList<String>();
        int statu = 0;
        try {
            URL jarURL = new URL(url.toString().substring(0, url.toString().indexOf("!/") + 2));
            JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
            JarFile jarFile = jarCon.getJarFile();
            Enumeration<JarEntry> jarEntrys = jarFile.entries();
            while (jarEntrys.hasMoreElements() && statu != 2) {
                JarEntry entry;
                try {
                    entry = jarEntrys.nextElement();
                }
                catch (Exception e) {
                    break;
                }
                String name = entry.getName();
                if (name.startsWith(path) && !entry.isDirectory()) {
                    if (statu == 0) {
                        statu = 1;
                    }
                    BufferedInputStream biput = new BufferedInputStream(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(name)));
                    try {
                        byte[] buffer = new byte[(int)entry.getSize()];
                        biput.read(buffer, 0, buffer.length);
                        String str = new String(buffer, StandardCharsets.UTF_8);
                        strs.add(str);
                        continue;
                    }
                    finally {
                        biput.close();
                        continue;
                    }
                }
                if (statu != 1) continue;
                statu = 2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return strs;
    }

    public Collection<Diagram> getDiagrams() {
        return this.nameAndDiagrams.values();
    }

    public List<String> getDiagramNames() {
        return new ArrayList<String>(this.nameAndDiagrams.keySet());
    }

    public Diagram getDiagramByName(String name) {
        return this.nameAndDiagrams.get(name);
    }

    public Diagram getUserDiagramByName(String name) {
        return this.userLoad(name);
    }
}

