/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.apply.plugin;

import com.af.v4.v3.apply.plugin.SM3Utils;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.legacy.math.linearalgebra.ByteUtils;

public final class Sm4Utils {
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    private static final String ENCODING = "UTF-8";

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static String encryptEcb(String key, String paramStr) throws Exception {
        byte[] keyData = key.getBytes(ENCODING);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = Sm4Utils.encryptEcbPadding(keyData, srcData);
        return Base64.getEncoder().encodeToString(cipherArray);
    }

    public static byte[] encryptEcbPadding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = Sm4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String key, String cipherText) throws Exception {
        byte[] keyData = key.getBytes(ENCODING);
        byte[] cipherData = Base64.getDecoder().decode(cipherText);
        byte[] srcData = Sm4Utils.decryptEcbPadding(keyData, cipherData);
        return new String(srcData, ENCODING);
    }

    public static byte[] decryptEcbPadding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = Sm4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = Sm4Utils.decryptEcbPadding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        boolean flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static String getSecretKey(String appSecret, String timestamp) throws Exception {
        String stringToSecretKey = timestamp + appSecret;
        String sm3Str = SM3Utils.encrypt(stringToSecretKey);
        return sm3Str.substring(0, 16);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

