package com.af.v4.v3.apply.plugin;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class ServiceNoGenerator {
    private final SqlService sqlService;
    private final EntityService entityService;


    public ServiceNoGenerator(SqlService sqlService, EntityService entityService) {
        this.sqlService = sqlService;
        this.entityService = entityService;
    }

    /**
     * 新的编号产生器，所有编号从1开始
     *
     * @param key 编号主键
     * @param len 产生的编号长度，不够前面补0。len=0，则不需要补前缀0
     * @return 产生的编号
     * @throws Exception 异常
     */
    public String getNo(String key, int len) throws Exception {
        long value = 0;
        int id = -1;
        String sql;
        if (DynamicDataSource.getDbType().equals("sqlserver")) {
            sql = "select id, f_key, f_value from t_sequence with(updlock,rowlock) where f_key='" + key + "'";
        } else {
            sql = "select id, f_key, f_value from t_sequence where f_key='" + key + "' for update";
        }
        JSONArray array = sqlService.querySQL("getNo", sql);
        if (!array.isEmpty()) {
            value = array.getJSONObject(0).getLong("f_value");
            id = array.getJSONObject(0).getInt("id");
        }
        // 编号+1
        value++;
        JSONObject entity = new JSONObject();
        entity.put("f_key", key);
        entity.put("f_value", value);
        // 保存结果
        if (id != -1) {
            entity.put("id", id);
        }
        entityService.partialSave("t_sequence", entity);
        String result = value + "";
        int resultLen = result.length();
        // 如果有长度限制，前面补0
        if (len != 0 && resultLen < len) {
            result = String.format("%0" + len + "d", Long.parseLong(result));
        }
        // 否则，直接返回
        return result;
    }
}
