package com.af.v4.v3.telephone;

import java.util.HashMap;
import java.util.Map;

public class ServiceDetailsTools {

    private static final Map<String, String> serviceActivityMap;

    static {
        serviceActivityMap = new HashMap<>();
        serviceActivityMap.put("维修单", "t_servicework");
        serviceActivityMap.put("预约单", "t_oppointmentend");
        serviceActivityMap.put("投诉单", "t_complanintend");
        serviceActivityMap.put("派单", "t_servicesend");
        serviceActivityMap.put("打回单", "t_site_back");
        serviceActivityMap.put("催单", "t_reminder");
        serviceActivityMap.put("信息维护", "t_telinformation");
        serviceActivityMap.put("结案", "t_serviceend");
        serviceActivityMap.put("回退单", "t_service_back");
    }

    /**
     * 通过步骤类型获取到响应的表明
     *
     * @param serviceType 步骤类型
     * @return 表名
     */
    public static String getServiceActivity(String serviceType) {
        if (serviceActivityMap.containsKey(serviceType)) {
            return serviceActivityMap.get(serviceType);
        }
        return "isNull";
    }

}
