/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.dto;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.runtime.dto.UpgradeField;
import com.af.v4.system.runtime.utils.DataTypeUtils;
import java.util.List;

public record UpgradeTable(String tableName, List<UpgradeField> fields) {
    public String getSearchSql() {
        DbType dbType = DynamicDataSource.getDbType();
        Dialect dialect = dbType.dialect;
        if (dialect.isOracleFamily()) {
            return "select 1 from user_tables where table_name = '" + this.tableName.toUpperCase() + "'";
        }
        if (dialect.isPostgresFamily()) {
            return "select 1 from information_schema.tables where table_name = '" + this.tableName.toLowerCase() + "'";
        }
        if (dialect.isMySqlFamily()) {
            return "select 1 from information_schema.tables where table_name = '" + this.tableName + "'";
        }
        if (dialect.isSQLServerFamily()) {
            return "select 1 from sysobjects where name = '" + this.tableName + "' and type = 'U'";
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + String.valueOf(dbType));
    }

    public String getCreateSql() {
        DbType dbType = DynamicDataSource.getDbType();
        Dialect dialect = dbType.dialect;
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(DataTypeUtils.getTableNameWithCase(this.tableName, dialect)).append(" (");
        for (int i = 0; i < this.fields.size(); ++i) {
            UpgradeField field = this.fields.get(i);
            String fieldName = field.field();
            String fieldType = field.type();
            String defaultValue = field.defaultValue();
            fieldName = DataTypeUtils.getFieldNameWithCase(fieldName, dialect);
            fieldType = DataTypeUtils.convertDataType(fieldType, dbType);
            sql.append(fieldName).append(" ").append(fieldType);
            if (defaultValue != null && !defaultValue.isEmpty()) {
                sql.append(" DEFAULT ").append(defaultValue);
            }
            if (i >= this.fields.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        if (dialect.isMySqlFamily()) {
            sql.append(" ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
        }
        return sql.toString();
    }
}

