/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.dto;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.runtime.utils.DataTypeUtils;

public record UpgradeField(String tableName, String field, String type, String defaultValue) {
    public static final String DEFAULT_NOW_DATE = "now";

    public UpgradeField(String tableName, String field, String type) {
        this(tableName, field, type, null);
    }

    public String getSearchSql() {
        DbType dbType = DynamicDataSource.getDbType();
        Dialect dialect = dbType.dialect;
        String tableName = DataTypeUtils.getTableNameWithCase(this.tableName(), dialect);
        String fieldName = DataTypeUtils.getFieldNameWithCase(this.field(), dialect);
        if (dialect.isOracleFamily()) {
            return "select 1 from user_tab_columns where table_name = '" + tableName + "' and column_name = '" + fieldName + "'";
        }
        if (dialect.isPostgresFamily()) {
            return "select 1 from information_schema.columns where table_name = '" + tableName + "' and column_name = '" + fieldName + "'";
        }
        if (dialect.isMySqlFamily()) {
            return "select 1 from information_schema.columns where table_name = '" + tableName + "' and column_name = '" + fieldName + "'";
        }
        if (dialect.isSQLServerFamily()) {
            return "select 1 from syscolumns where id = object_id('" + tableName + "') and name = '" + fieldName + "'";
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + String.valueOf(dbType));
    }

    public String getAddSql() {
        DbType dbType = DynamicDataSource.getDbType();
        Dialect dialect = dbType.dialect;
        String convertedType = DataTypeUtils.convertDataType(this.type, dbType);
        String tableName = DataTypeUtils.getTableNameWithCase(this.tableName(), dialect);
        String fieldName = DataTypeUtils.getFieldNameWithCase(this.field(), dialect);
        StringBuilder sql = new StringBuilder();
        if (dialect.isOracleFamily()) {
            sql.append("alter table ").append(tableName.toUpperCase()).append(" add ").append(fieldName).append(" ").append(convertedType);
        } else if (dialect.isPostgresFamily()) {
            sql.append("alter table ").append(tableName.toLowerCase()).append(" add column ").append(fieldName).append(" ").append(convertedType);
        } else if (dialect.isMySqlFamily()) {
            sql.append("alter table ").append(tableName).append(" add column ").append(fieldName).append(" ").append(convertedType);
        } else if (dialect.isSQLServerFamily()) {
            sql.append("alter table ").append(tableName).append(" add ").append(fieldName).append(" ").append(convertedType);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b: " + String.valueOf(dbType));
        }
        if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
            sql.append(" default ");
            if (DEFAULT_NOW_DATE.equalsIgnoreCase(this.defaultValue)) {
                if (dialect.isOracleFamily()) {
                    sql.append("SYSDATE");
                } else if (dialect.isPostgresFamily()) {
                    sql.append("CURRENT_TIMESTAMP");
                } else if (dialect.isMySqlFamily()) {
                    sql.append("NOW()");
                } else if (dialect.isSQLServerFamily()) {
                    sql.append("GETDATE()");
                } else {
                    sql.append("CURRENT_TIMESTAMP");
                }
            } else {
                sql.append(this.defaultValue);
            }
        }
        return sql.toString();
    }
}

