/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.runtime.upgrade.BaseUpgradeAppBootstrap;
import com.af.v4.system.runtime.upgrade.UpgradePathExecutor;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class UpgradePathManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradePathManager.class);
    private final RedisService redisService;
    private final ApplicationService applicationService;
    private final BaseUpgradeAppBootstrap upgradeAppBootstrap;
    private final BaseUpgradeAppBootstrap upgradeCoreBootstrap;

    public UpgradePathManager(RedisService redisService, ApplicationService applicationService, @Qualifier(value="upgradeAppBootstrap") BaseUpgradeAppBootstrap upgradeAppBootstrap, @Qualifier(value="upgradeCoreBootstrap") BaseUpgradeAppBootstrap upgradeCoreBootstrap) {
        this.redisService = redisService;
        this.applicationService = applicationService;
        this.upgradeAppBootstrap = upgradeAppBootstrap;
        this.upgradeCoreBootstrap = upgradeCoreBootstrap;
    }

    private String getUpgradeKey(UpgradeType upgradeType) {
        return switch (upgradeType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "System@CoreVersion";
            case 1 -> "System@AppVersion-" + this.applicationService.getApplicationName();
        };
    }

    private Integer getVersionCode(UpgradeType upgradeType) {
        return switch (upgradeType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ApplicationService.getSystemV4VersionCode();
            case 1 -> ApplicationService.getAppVersionCode();
        };
    }

    private String getVersion(UpgradeType upgradeType) {
        return switch (upgradeType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ApplicationService.getSystemV4Version();
            case 1 -> ApplicationService.getAppVersion();
        };
    }

    private UpgradePath buildUpgradePath(UpgradeType upgradeType) {
        if (upgradeType == UpgradeType.CORE_UPGRADE) {
            LOGGER.info("[{}] \u68c0\u67e5\u6846\u67b6\u66f4\u65b0...", (Object)this.applicationService.getApplicationName());
        } else {
            LOGGER.info("[{}] \u68c0\u67e5\u5e94\u7528\u66f4\u65b0...", (Object)this.applicationService.getApplicationName());
        }
        String upgradeKey = this.getUpgradeKey(upgradeType);
        String fromVersion = (String)this.redisService.get(upgradeKey);
        int fromVersionCode = fromVersion == null ? 0 : ApplicationService.buildVersionCode((String)fromVersion);
        String toVersion = this.getVersion(upgradeType);
        int toVersionCode = this.getVersionCode(upgradeType);
        if (fromVersionCode >= toVersionCode) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5185\u5bb9.");
            this.redisService.set(upgradeKey, (Object)toVersion);
            return null;
        }
        TreeMap<Integer, UpgradePathExecutor> upgradePathExecutorMap = new TreeMap<Integer, UpgradePathExecutor>();
        BaseUpgradeAppBootstrap bootstrap = upgradeType == UpgradeType.CORE_UPGRADE ? this.upgradeCoreBootstrap : this.upgradeAppBootstrap;
        for (UpgradePathExecutor executor : bootstrap.getAllExecutor()) {
            if (executor.targetVersionCode() <= fromVersionCode) continue;
            upgradePathExecutorMap.put(executor.targetVersionCode(), executor);
        }
        if (upgradePathExecutorMap.isEmpty()) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5185\u5bb9.");
            this.redisService.set(upgradeKey, (Object)toVersion);
            return null;
        }
        LOGGER.info("\u5f85\u66f4\u65b0\u6570\u636e\u5305\u6570\u91cf\uff1a{}", (Object)upgradePathExecutorMap.size());
        return new UpgradePath(upgradePathExecutorMap, fromVersion);
    }

    public void executeUpgrade(UpgradeType upgradeType) {
        String upgradeKey = this.getUpgradeKey(upgradeType);
        this.redisService.syncLock(upgradeKey, () -> {
            UpgradePath upgradePath = this.buildUpgradePath(upgradeType);
            if (upgradePath == null) {
                return null;
            }
            this.upgrade(upgradeType, upgradePath);
            return null;
        });
    }

    public void upgrade(UpgradeType upgradeType, UpgradePath upgradePath) {
        String upgradeKey = this.getUpgradeKey(upgradeType);
        Map<Integer, UpgradePathExecutor> upgradePathExecutorMap = upgradePath.executors;
        String fromVersion = upgradePath.fromVersion;
        for (UpgradePathExecutor executor : upgradePathExecutorMap.values()) {
            LOGGER.info("[{}][{}] \u5f00\u59cb\u8fdb\u884c\u66f4\u65b0 ===============> {} to {}", new Object[]{upgradeType.name(), this.applicationService.getApplicationName(), fromVersion, executor.targetVersion()});
            try {
                executor.upgrade();
                this.redisService.set(upgradeKey, (Object)executor.targetVersion());
                LOGGER.info("{} => {} done.", (Object)fromVersion, (Object)executor.targetVersion());
                fromVersion = executor.targetVersion();
            }
            catch (Exception e) {
                LOGGER.error("\u670d\u52a1\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                throw new ServiceException("\u670d\u52a1\u66f4\u65b0\u5931\u8d25\uff0c\u7a0b\u5e8f\u5df2\u5f3a\u5236\u4e2d\u6b62.");
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.applicationService.getEnvType() != EnvType.LOCAL) {
            this.executeUpgrade(UpgradeType.CORE_UPGRADE);
            this.executeUpgrade(UpgradeType.APP_UPGRADE);
        }
    }

    public static enum UpgradeType {
        CORE_UPGRADE,
        APP_UPGRADE;

    }

    public record UpgradePath(Map<Integer, UpgradePathExecutor> executors, String fromVersion) {
    }
}

