/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.workflow;

import com.af.v4.system.common.core.proxy.jpa.IConditionProxy;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowPathFinder {
    @Autowired
    private EntityService entityService;

    public JSONArray findPath(JSONObject stepMap, JSONArray extraData, String workFlowId, String curUserId) {
        JSONObject node;
        JSONArray path = new JSONArray();
        HashSet<String> visited = new HashSet<String>();
        LinkedHashMap<String, JSONObject> filteredSteps = new LinkedHashMap<String, JSONObject>();
        for (int i = 0; i < extraData.length(); ++i) {
            JSONObject step = extraData.getJSONObject(i);
            String id = String.valueOf(step.optInt("id"));
            if (filteredSteps.containsKey(id)) {
                ArrayList<String> toRemove = new ArrayList<String>();
                boolean startRemove = false;
                for (String key : filteredSteps.keySet()) {
                    if (startRemove) {
                        toRemove.add(key);
                    }
                    if (!key.equals(id)) continue;
                    startRemove = true;
                }
                for (String r : toRemove) {
                    filteredSteps.remove(r);
                }
            }
            filteredSteps.put(id, step);
        }
        if (filteredSteps.isEmpty()) {
            return path;
        }
        String curId = String.valueOf(((JSONObject)filteredSteps.values().iterator().next()).optInt("id"));
        int i = 1;
        while (curId != null && !visited.contains(curId) && (node = stepMap.optJSONObject(curId)) != null) {
            JSONObject stepInfo = filteredSteps.getOrDefault(curId, new JSONObject());
            node.put("handler", (Object)stepInfo.optString("name"));
            node.put("f_handler_id", (Object)stepInfo.optString("f_handler_id"));
            node.put("date", (Object)stepInfo.optString("date"));
            node.put("note", (Object)stepInfo.optString("note"));
            node.put("deadline", (Object)stepInfo.optString("deadline"));
            node.put("status", stepInfo.opt("status"));
            node.put("f_data", stepInfo.opt("f_data"));
            node.put("sequence", i++);
            if (curUserId != null && "1".equals(stepInfo.optString("status"))) {
                node.put("isCurrently", false);
                int id = stepInfo.getInt("t_workflow_step_id");
                IConditionProxy condition = EntityService.getCondition();
                condition = condition.eq("f_step_id", (Object)id).and().eq("f_handler_id", (Object)curUserId).and().eq("f_workflow_id", (Object)workFlowId);
                JSONArray byCondition = this.entityService.getByCondition("t_workflow_step_users", condition);
                if (!byCondition.isEmpty()) {
                    node.put("isCurrently", true);
                }
            }
            path.put((Object)node);
            visited.add(curId);
            String branchType = JsonTools.convertToJson((String)node.optString("properties", "{}")).optString("branchType");
            if ("condition".equalsIgnoreCase(node.optString("type")) && "conditionalBranch".equalsIgnoreCase(branchType) && !FlowPathFinder.hasConditionResult(stepInfo)) {
                FlowPathFinder.appendRemainingSteps(path, stepMap, visited, curId, i);
                break;
            }
            if ("parallelBranch".equalsIgnoreCase(branchType)) {
                List<String> nextIds = FlowPathFinder.getNextParallelSteps(stepMap, curId);
                if (!nextIds.isEmpty()) {
                    for (String nextId : nextIds) {
                        JSONObject nextNode;
                        if (visited.contains(nextId) || (nextNode = stepMap.optJSONObject(nextId)) == null) continue;
                        JSONObject nextStepInfo = filteredSteps.getOrDefault(nextId, new JSONObject());
                        nextNode.put("handler", (Object)nextStepInfo.optString("name"));
                        nextNode.put("f_handler_id", (Object)nextStepInfo.optString("f_handler_id"));
                        nextNode.put("date", (Object)nextStepInfo.optString("date"));
                        nextNode.put("note", (Object)nextStepInfo.optString("note"));
                        nextNode.put("deadline", (Object)nextStepInfo.optString("deadline"));
                        nextNode.put("status", nextStepInfo.opt("status"));
                        nextNode.put("f_data", nextStepInfo.opt("f_data"));
                        nextNode.put("sequence", i++);
                        path.put((Object)nextNode);
                        visited.add(nextId);
                    }
                    String mergeNodeId = FlowPathFinder.findMergeNode(stepMap, nextIds);
                    if (mergeNodeId != null) {
                        if (!visited.contains(mergeNodeId)) {
                            curId = mergeNodeId;
                            continue;
                        }
                        JSONObject mergeStepInfo = filteredSteps.getOrDefault(mergeNodeId, new JSONObject());
                        curId = FlowPathFinder.getNextStep(stepMap, mergeNodeId, mergeStepInfo);
                        continue;
                    }
                    curId = nextIds.isEmpty() ? null : FlowPathFinder.getNextStep(stepMap, nextIds.get(0), filteredSteps.getOrDefault(nextIds.get(0), new JSONObject()));
                    continue;
                }
                curId = null;
                continue;
            }
            curId = FlowPathFinder.getNextStep(stepMap, curId, stepInfo);
        }
        return path;
    }

    private static String findMergeNode(JSONObject stepMap, List<String> parallelNodeIds) {
        if (parallelNodeIds == null || parallelNodeIds.isEmpty()) {
            return null;
        }
        String firstNodeId = parallelNodeIds.get(0);
        JSONObject firstNode = stepMap.optJSONObject(firstNodeId);
        if (firstNode == null) {
            return null;
        }
        JSONObject props = firstNode.optJSONObject("properties");
        if (props == null) {
            return null;
        }
        JSONArray actions = props.optJSONArray("actions");
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        for (int i = 0; i < actions.length(); ++i) {
            String toId;
            JSONObject action = actions.getJSONObject(i);
            if (!"submit".equalsIgnoreCase(action.optString("type")) || (toId = String.valueOf(action.optInt("to"))).equals("0") || toId.equals("null")) continue;
            return toId;
        }
        String toId = String.valueOf(actions.getJSONObject(0).optInt("to"));
        if (!toId.equals("0") && !toId.equals("null")) {
            return toId;
        }
        return null;
    }

    private static List<String> getNextParallelSteps(JSONObject stepMap, String curId) {
        JSONObject curStep = stepMap.optJSONObject(curId);
        if (curStep == null) {
            return new ArrayList<String>();
        }
        JSONObject props = curStep.optJSONObject("properties");
        if (props == null) {
            return new ArrayList<String>();
        }
        JSONArray actions = props.optJSONArray("actions");
        if (actions == null || actions.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> nextIds = new ArrayList<String>();
        for (int i = 0; i < actions.length(); ++i) {
            JSONObject action = actions.getJSONObject(i);
            String toId = String.valueOf(action.optInt("to"));
            if (toId.equals("0") || toId.equals("null")) continue;
            nextIds.add(toId);
        }
        return nextIds;
    }

    private static String getNextStep(JSONObject stepMap, String curId, JSONObject stepInfo) {
        JSONObject fDataJson;
        String fData;
        JSONObject curStep = stepMap.optJSONObject(curId);
        if (curStep == null) {
            return null;
        }
        JSONObject props = curStep.optJSONObject("properties");
        if (props == null) {
            return null;
        }
        JSONArray actions = props.optJSONArray("actions");
        if (actions == null || actions.isEmpty()) {
            return null;
        }
        String type = curStep.optString("type");
        if ("condition".equalsIgnoreCase(type) && stepInfo != null && (fData = stepInfo.optString("f_data")) != null && !fData.isEmpty() && (fDataJson = new JSONObject(fData)).has("__expressionRs")) {
            return String.valueOf(fDataJson.optInt("__expressionRs"));
        }
        for (int i = 0; i < actions.length(); ++i) {
            JSONObject action = actions.getJSONObject(i);
            if (!"submit".equalsIgnoreCase(action.optString("type"))) continue;
            return String.valueOf(action.optInt("to"));
        }
        return String.valueOf(actions.getJSONObject(0).optInt("to"));
    }

    private static boolean hasConditionResult(JSONObject stepInfo) {
        if (stepInfo == null) {
            return false;
        }
        String fData = stepInfo.optString("f_data");
        if (fData == null || fData.isEmpty()) {
            return false;
        }
        try {
            JSONObject fDataJson = new JSONObject(fData);
            return fDataJson.has("__expressionRs");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void appendRemainingSteps(JSONArray path, JSONObject stepMap, Set<String> visited, String startId, int sequence) {
        for (String key : stepMap.keySet()) {
            JSONObject node;
            if (visited.contains(key) || (node = stepMap.optJSONObject(key)) == null) continue;
            node.put("sequence", sequence++);
            path.put((Object)node);
            visited.add(key);
        }
    }
}

