/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.udp;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.DatagramPacketChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public class UdpServer
extends SocketServer<Bootstrap, Channel> {
    private EventLoopGroup workerGroup;
    protected EventExecutorGroup businessGroup;

    @Override
    protected AbstractBootstrap<Bootstrap, Channel> initBootstrap() {
        Class<EpollDatagramChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.workerGroup = new EpollEventLoopGroup();
            channelClass = EpollDatagramChannel.class;
        } else {
            this.workerGroup = new NioEventLoopGroup();
            channelClass = NioDatagramChannel.class;
        }
        int cores = Runtime.getRuntime().availableProcessors();
        this.businessGroup = new DefaultEventExecutorGroup(cores * 2, (ThreadFactory)new DefaultThreadFactory("socket-business-thread", true));
        return ((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(this){
            final /* synthetic */ UdpServer this$0;
            {
                UdpServer udpServer = this$0;
                Objects.requireNonNull(udpServer);
                this.this$0 = udpServer;
            }

            protected void initChannel(DatagramChannel ch) {
                Boolean debug = SocketServerManager.getConfigItemByChannel((Channel)ch).map(SocketConfigItem::getDebugLogging).orElse(false);
                if (this.this$0.LOGGER.isDebugEnabled() || debug.booleanValue()) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
                }
                ch.pipeline().addLast(this.this$0.businessGroup, new ChannelHandler[]{new DatagramPacketChannelHandler()});
            }
        });
    }

    @Override
    public void destroy() {
        this.closeAllChannels();
        if (this.businessGroup != null) {
            this.businessGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
    }
}

