/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client.modbus;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ModbusTCPChannelHandler;
import com.af.v4.system.common.socket.core.client.SocketClient;
import com.af.v4.system.common.socket.core.decoder.ModbusRequestDecoder;
import com.af.v4.system.common.socket.core.encoder.ModbusResponseEncoder;
import com.af.v4.system.common.socket.core.server.modbus.message.ModbusSendUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;

public class ModBusClient
extends SocketClient {
    public static final Cache<@NonNull Short, ClientEvent> MOD_BUS_EVENT_MAP = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap() {
        Class<EpollSocketChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }
        return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusRequestDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusResponseEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusTCPChannelHandler()});
            }
        });
    }

    @Override
    @PreDestroy
    public void destroy() {
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
        if (!socketClientConfigItem.getEvents().isEmpty()) {
            int taskCount = (int)Math.ceil((double)socketClientConfigItem.getEvents().size() / 2.0) + 1;
            try (ScheduledExecutorService executor = Executors.newScheduledThreadPool(taskCount);){
                List<Runnable> tasks = socketClientConfigItem.getEvents().stream().map(event -> () -> {
                    short transactionIdentifier = ModbusSendUtil.getTransactionIdentifier(event.getAddress(), event.getLength());
                    MOD_BUS_EVENT_MAP.put((Object)transactionIdentifier, event);
                    event.setTransactionId(transactionIdentifier);
                    ModbusSendUtil.readData(socketClientConfigItem.getAddress(), event);
                }).toList();
                for (int i = 0; i < tasks.size(); ++i) {
                    Runnable task = tasks.get(i);
                    long interval = socketClientConfigItem.getEvents().get(i).getTime();
                    executor.scheduleAtFixedRate(task, 0L, interval, TimeUnit.SECONDS);
                }
            }
        }
    }
}

