/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.config.SocketConfig;
import com.af.v4.system.common.socket.config.SocketSslConfig;
import com.af.v4.system.common.socket.core.client.SocketClient;
import com.af.v4.system.common.socket.core.client.modbus.ModBusClient;
import com.af.v4.system.common.socket.core.client.tcp.TcpClient;
import com.af.v4.system.common.socket.core.ssl.SocketSslContextFactory;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketClientManager.class);
    private static final Map<String, SocketClientConfigItem> socketClientConfigMap = new HashMap<String, SocketClientConfigItem>();
    private final SocketConfig socketConfig;
    private final List<SocketClient> socketServerList = new ArrayList<SocketClient>();

    public SocketClientManager(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public static SocketClientConfigItem getSocketConfigItemByPort(String port) {
        return socketClientConfigMap.get(port);
    }

    @PostConstruct
    public void startAll() {
        List<SocketClientConfigItem> socketConfigItemList = this.socketConfig.getSocketServerClientList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                if (item.getType() == SocketTypeEnum.TCP) {
                    this.logSslConfig((SocketClientConfigItem)item);
                }
                SocketClient socketServer = this.createSocketClient((SocketClientConfigItem)item);
                this.socketServerList.add(socketServer);
                socketClientConfigMap.put(item.getAddress(), (SocketClientConfigItem)item);
                if (socketServer != null) {
                    socketServer.connect((SocketClientConfigItem)item);
                }
            });
        }
    }

    private void logSslConfig(SocketClientConfigItem item) {
        SocketSslConfig sslConfig = item.getSslConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            if (sslConfig.hasKeyStore()) {
                List<String> keyAliases = SocketSslContextFactory.getCertificateAliases(sslConfig, true);
                LOGGER.info("\u5ba2\u6237\u7aef[{}] SSL\u5df2\u542f\u7528 - \u5bc6\u94a5\u5e93\u8def\u5f84: {}, \u8bc1\u4e66\u522b\u540d: {}", new Object[]{item.getName(), sslConfig.getKeyStorePath(), keyAliases.isEmpty() ? "\u65e0" : String.join((CharSequence)", ", keyAliases)});
            }
            if (sslConfig.hasTrustStore()) {
                List<String> trustAliases = SocketSslContextFactory.getCertificateAliases(sslConfig, false);
                LOGGER.info("\u5ba2\u6237\u7aef[{}] SSL\u5df2\u542f\u7528 - \u4fe1\u4efb\u5e93\u8def\u5f84: {}, \u8bc1\u4e66\u522b\u540d: {}", new Object[]{item.getName(), sslConfig.getTrustStorePath(), trustAliases.isEmpty() ? "\u65e0" : String.join((CharSequence)", ", trustAliases)});
            }
            if (!sslConfig.isVerifyPeerCertificate()) {
                LOGGER.warn("\u5ba2\u6237\u7aef[{}] SSL\u5df2\u542f\u7528\u4f46\u672a\u6821\u9a8c\u8bc1\u4e66 - \u5c06\u4fe1\u4efb\u6240\u6709\u8bc1\u4e66\uff0c\u5b58\u5728\u5b89\u5168\u98ce\u9669", (Object)item.getName());
            }
        } else {
            LOGGER.warn("\u5ba2\u6237\u7aef[{}] SSL\u672a\u542f\u7528 - \u8fde\u63a5\u5c06\u4f7f\u7528\u660e\u6587\u4f20\u8f93\uff0c\u5b58\u5728\u5b89\u5168\u98ce\u9669", (Object)item.getName());
        }
    }

    private SocketClient createSocketClient(SocketClientConfigItem item) {
        SocketClient socketClient = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketClient = new TcpClient();
        } else if (item.getType() == SocketTypeEnum.MODBUS_TCP) {
            socketClient = new ModBusClient();
        }
        return socketClient;
    }

    @PreDestroy
    public void destroyAll() {
        for (SocketClient socketServer : this.socketServerList) {
            socketServer.destroy();
        }
    }
}

