/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.tcp;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ThreadFactory;

public abstract class AbstractTcpServer
extends SocketServer<ServerBootstrap, ServerChannel> {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    protected EventExecutorGroup businessGroup;

    @Override
    protected AbstractBootstrap<ServerBootstrap, ServerChannel> initBootstrap() {
        Class<EpollServerSocketChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        int cores = Runtime.getRuntime().availableProcessors();
        this.businessGroup = new DefaultEventExecutorGroup(cores * 2 + 1, (ThreadFactory)new DefaultThreadFactory("socket-business-thread", true));
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(channelClass)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                Integer idle = SocketServerManager.getConfigItemByChannel((Channel)ch).map(SocketConfigItem::getIdleSeconds).orElse(60);
                Boolean debug = SocketServerManager.getConfigItemByChannel((Channel)ch).map(SocketConfigItem::getDebugLogging).orElse(false);
                if (AbstractTcpServer.this.LOGGER.isDebugEnabled() || debug.booleanValue()) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, idle <= 0 ? 60 : idle)});
                AbstractTcpServer.this.setChildHandler(ch);
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.useKeepAlive()).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
    }

    protected boolean useKeepAlive() {
        return true;
    }

    protected abstract void setChildHandler(SocketChannel var1);

    protected abstract void destroyOtherGroup();

    @Override
    public void destroy() {
        this.closeAllChannels();
        if (this.businessGroup != null) {
            this.businessGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        this.destroyOtherGroup();
    }
}

