/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModbusRequestDecoder
extends ByteToMessageDecoder {
    private final Logger LOGGER = LoggerFactory.getLogger(ModbusRequestDecoder.class);

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (!byteBuf.isReadable()) {
                return;
            }
            byteBuf.markReaderIndex();
            if (byteBuf.readableBytes() < 6) {
                byteBuf.resetReaderIndex();
                return;
            }
            byteBuf.skipBytes(4);
            int lengthField = byteBuf.readUnsignedShort();
            int frameLength = 6 + lengthField;
            byteBuf.resetReaderIndex();
            if (byteBuf.readableBytes() < frameLength) {
                return;
            }
            ByteBuf frame = byteBuf.readRetainedSlice(frameLength);
            list.add(frame);
        }
        catch (Exception e) {
            this.LOGGER.error("Modbus \u89e3\u7801\u5f02\u5e38", (Throwable)e);
        }
    }
}

