//package com.af.v4.system.common.socket.core.client.mqtt;
//
//import com.af.v4.system.common.core.utils.uuid.UUID;
//import com.af.v4.system.common.liuli.utils.ApplicationUtils;
//import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
//import com.af.v4.system.common.socket.config.SocketClientConfigItem;
//import com.af.v4.system.common.socket.core.channel.impl.MqttClientChannelHandler;
//import com.af.v4.system.common.socket.core.channel.impl.MqttServerChannelHandler;
//import com.af.v4.system.common.socket.core.server.SocketClient;
//import io.netty.bootstrap.Bootstrap;
//import io.netty.channel.*;
//import io.netty.channel.epoll.EpollEventLoopGroup;
//import io.netty.channel.epoll.EpollSocketChannel;
//import io.netty.channel.nio.NioEventLoopGroup;
//import io.netty.channel.socket.SocketChannel;
//import io.netty.channel.socket.nio.NioSocketChannel;
//import io.netty.handler.codec.mqtt.*;
//
//import io.netty.util.CharsetUtil;
//import jakarta.annotation.PreDestroy;
//
///**
// * MQTT客户端
// */
//public class MqttClient extends SocketClient<ServerChannel> {
//    private EventLoopGroup group;
//
//    @Override
//    protected Bootstrap initBootstrap(SocketClientConfigItem socketConfigItem) {
//        Class<? extends Channel> channelClass;
//        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
//            group = new EpollEventLoopGroup();
//            channelClass = EpollSocketChannel.class;
//        } else {
//            group = new NioEventLoopGroup();
//            channelClass = NioSocketChannel.class;
//        }
//
//        return new Bootstrap()
//                .group(group)
//                .channel(channelClass)
//                .handler(new ChannelInitializer<SocketChannel>() {
//                    @Override
//                    protected void initChannel(SocketChannel ch) {
//                        ch.pipeline()
//                                .addLast("encoder", MqttEncoder.INSTANCE)
//                                .addLast("decoder", new MqttDecoder())
//                                .addLast(new MqttClientChannelHandler());
//                    }
//                })
//                .option(ChannelOption.TCP_NODELAY, true)
//                .option(ChannelOption.SO_KEEPALIVE, true);
//    }
//
//    @PreDestroy
//    public void destroy() {
//        if (group != null) {
//            group.shutdownGracefully();
//        }
//    }
//
//    @Override
//    public void senMes(SocketClientConfigItem socketClientConfigItem) {
//
//    }
//
//    public void connectSever(SocketClientConfigItem socketConfigItem, Channel channel) {
//        MqttConnectVariableHeader mqttConnectVariableHeader = new MqttConnectVariableHeader("MQTT", 4, true, true, false, 0, false, true, 60);
//        String uuid = UUID.randomUUID().toString().replace("-", "");
//        MqttConnectPayload connectPayload = new MqttConnectPayload(uuid, null, null, socketConfigItem.getUsername(), socketConfigItem.getPassword().getBytes(CharsetUtil.UTF_8));
//        MqttFixedHeader mqttFixedHeaderInfo = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_LEAST_ONCE, false, 0);
//        MqttConnectMessage connectMessage = new MqttConnectMessage(mqttFixedHeaderInfo, mqttConnectVariableHeader, connectPayload);
//        channel.writeAndFlush(connectMessage);
//    }
//}
