/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.mqtt.message;

import com.af.v4.system.common.socket.core.channel.impl.mqtt.MqttMsgBack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttUtils {
    private static final Logger log = LoggerFactory.getLogger(MqttUtils.class);
    private final AtomicInteger nextMessageId = new AtomicInteger(1);
    private static final ReentrantLock LOCK = new ReentrantLock();

    public void publish(String topic, String message, int qos, Boolean retain) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.valueOf((int)qos), retain.booleanValue(), 0);
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, this.getNewMessageId().messageId());
        ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
        ByteBuf byteBuf = allocator.buffer();
        byteBuf.writeCharSequence((CharSequence)message, StandardCharsets.UTF_8);
        MqttPublishMessage mqttPublishMessage = new MqttPublishMessage(fixedHeader, variableHeader, byteBuf);
        new MqttMsgBack().subscribSend((MqttMessage)mqttPublishMessage);
    }

    private MqttMessageIdVariableHeader getNewMessageId() {
        LOCK.lock();
        try {
            this.nextMessageId.compareAndSet(65535, 1);
            int messageId = this.nextMessageId.getAndIncrement();
            MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)messageId);
            return mqttMessageIdVariableHeader;
        }
        finally {
            LOCK.unlock();
        }
    }
}

