package com.af.v4.system.common.socket.core.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ModbusRequestDecoder extends ByteToMessageDecoder {
    private final Logger LOGGER = LoggerFactory.getLogger(ModbusRequestDecoder.class);

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (!byteBuf.isReadable()) {
                return;
            }
            // 基于 MBAP 长度字段分帧：length 字段包含 unitId+functionCode+data 的长度
            // MBAP: transactionId(2) + protocolId(2) + length(2) + unitId(1) + functionCode(1) + data(N)
            // 这里按可用数据尽量解一帧；若不足则等待更多数据
            byteBuf.markReaderIndex();
            if (byteBuf.readableBytes() < 6) {
                byteBuf.resetReaderIndex();
                return;
            }
            byteBuf.skipBytes(4); // 跳过 transactionId + protocolId
            int lengthField = byteBuf.readUnsignedShort(); // unitId+functionCode+data 的长度
            int frameLength = 6 /*header before length*/ + lengthField; // 总长度 = 6(含length) + lengthField
            byteBuf.resetReaderIndex();
            if (byteBuf.readableBytes() < frameLength) {
                return; // 半包，等待
            }
            ByteBuf frame = byteBuf.readRetainedSlice(frameLength);
            list.add(frame);
        } catch (Exception e) {
            LOGGER.error("Modbus 解码异常", e);
        }
    }
}
