package com.af.v4.system.common.socket.core.client.mqtt;

import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.channel.ChannelId;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MQTTSubscribeManager {
    // 保存MQTT订阅地址和channelid,当推送数据时，会向此订阅地址的多个channel发送数据
    private static final Map<String, List<ChannelId>> subscribeMap = new ConcurrentHashMap<>();

    public static boolean hasSubscribe(String topicName) {
        return subscribeMap.containsKey(topicName);
    }

    public static void registerSubscribe(String topicName, List<ChannelId> channelId) {
        subscribeMap.put(topicName, channelId);
    }

    public static List<ChannelId> getSubscribe(String topicName) {
        return subscribeMap.get(topicName);
    }

    public static void removeSubscribe(String topicName, ChannelId channelId) {
        subscribeMap.get(topicName).remove(channelId);
    }

    public static Map<String, List<ChannelId>> getSubscribeMap() {
        return subscribeMap;
    }

    /**
     * 设备移除和订阅的topic
     */
    public static void MQTTRemoveChannel(ChannelId channelId) {
        if (ClientManager.isExistChannel(channelId)) {
            ClientManager.remove(channelId);
            // 移除topic中的这个设备的channelid
            for (Map.Entry<String, List<ChannelId>> listEntry : subscribeMap.entrySet()) {
                listEntry.getValue().remove(channelId);
            }
        }
    }
}
