/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.config.SocketConfig;
import com.af.v4.system.common.socket.core.client.modbus.ModBusClient;
import com.af.v4.system.common.socket.core.client.tcp.TcpClient;
import com.af.v4.system.common.socket.core.server.SocketClient;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketClientManager.class);
    private static final Map<String, SocketClientConfigItem> socketClientConfigMap = new HashMap<String, SocketClientConfigItem>();
    private final SocketConfig socketConfig;
    private final List<SocketClient<?>> socketServerList = new ArrayList();

    public SocketClientManager(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public static SocketClientConfigItem getSocketConfigItemByPort(String port) {
        return socketClientConfigMap.get(port);
    }

    @PostConstruct
    public void startAll() {
        List<SocketClientConfigItem> socketConfigItemList = this.socketConfig.getSocketServerClientList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                SocketClient<?> socketServer = this.createSocketClient((SocketClientConfigItem)item);
                this.socketServerList.add(socketServer);
                socketClientConfigMap.put(item.getAddress(), (SocketClientConfigItem)item);
                if (socketServer != null) {
                    socketServer.connect((SocketClientConfigItem)item);
                }
            });
        }
    }

    private SocketClient<?> createSocketClient(SocketClientConfigItem item) {
        SocketClient socketClient = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketClient = new TcpClient();
        } else if (item.getType() == SocketTypeEnum.MODBUS_TCP) {
            socketClient = new ModBusClient();
        }
        return socketClient;
    }

    @PreDestroy
    public void destroyAll() {
        for (SocketClient<?> socketServer : this.socketServerList) {
            socketServer.destroy();
        }
    }
}

