/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.mqtt;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.MqttServerChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import jakarta.annotation.PreDestroy;

public class MqttServer
extends SocketServer<ServerBootstrap, ServerChannel> {
    private static final int MAX_INCOMING_MESSAGE_SIZE = 262144;
    private final SocketConfigItem configItem;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public MqttServer(SocketConfigItem configItem) {
        this.configItem = configItem;
    }

    @Override
    protected AbstractBootstrap<ServerBootstrap, ServerChannel> initBootstrap() {
        Class<EpollServerSocketChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        try {
            return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(channelClass)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    Integer idle = SocketServerManager.getConfigItemByChannel((Channel)ch).map(SocketConfigItem::getIdleSeconds).orElse(60);
                    Boolean debug = SocketServerManager.getConfigItemByChannel((Channel)ch).map(SocketConfigItem::getDebugLogging).orElse(false);
                    if (MqttServer.this.LOGGER.isDebugEnabled() || debug.booleanValue()) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, idle <= 0 ? 60 : idle)}).addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE).addLast("decoder", (ChannelHandler)new MqttDecoder(262144)).addLast(new ChannelHandler[]{new MqttServerChannelHandler(MqttServer.this.configItem)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        }
        catch (Exception e) {
            this.LOGGER.error("MqttServer initBootstrap error", (Throwable)e);
            this.destroy();
            return null;
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.closeAllChannels();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

