/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.filter;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.context.SecurityContextHolder;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.security.auth.AuthUtil;
import com.af.v4.system.common.security.utils.SecurityUtils;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.security.SignatureException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;

public class ScopedUserContextFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopedUserContextFilter.class);

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) {
        String userIdValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"id");
        String userNameValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"f_username");
        String userKeyValue = ServletUtils.getHeader((HttpServletRequest)request, (String)"user_key");
        ConcurrentHashMap<String, String> userContextMap = new ConcurrentHashMap<String, String>(6);
        userContextMap.put("id", userIdValue == null ? "" : userIdValue);
        userContextMap.put("f_username", userNameValue == null ? "" : userNameValue);
        userContextMap.put("user_key", userKeyValue == null ? "" : userKeyValue);
        String token = SecurityUtils.getToken();
        if (StringUtils.isNotEmpty((String)token)) {
            try {
                LoginUser loginUser = AuthUtil.getLoginUser(token);
                if (StringUtils.isNotNull((Object)loginUser)) {
                    AuthUtil.verifyLoginUserExpire(loginUser);
                    userContextMap.put("login_user", (String)loginUser);
                }
            }
            catch (MalformedJwtException | SignatureException loginUser) {
            }
            catch (JwtException e) {
                LOGGER.error("JWT \u89e3\u6790\u5931\u8d25", (Throwable)e);
            }
        }
        ScopedValue.where(SecurityContextHolder.getScopedUserInfo(), userContextMap).run(() -> {
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

