/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.auth;

import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.enums.Logical;
import com.af.v4.system.common.core.exception.auth.NotLoginException;
import com.af.v4.system.common.core.exception.auth.NotPermissionException;
import com.af.v4.system.common.core.exception.auth.NotRoleException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.security.annotation.RequiresPermissions;
import com.af.v4.system.common.security.annotation.RequiresRoles;
import com.af.v4.system.common.security.service.TokenService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.PatternMatchUtils;

public class AuthLogic {
    private static final String ALL_PERMISSION = "*:*:*";
    private static final String SUPER_ADMIN = "\u8d85\u7ea7\u7ba1\u7406\u5458";
    public final TokenService tokenService = (TokenService)SpringUtils.getBean(TokenService.class);

    public void logout() {
        String token = SecurityUtils.getToken();
        if (token == null) {
            return;
        }
        this.logoutByToken(token);
    }

    public void logoutByToken(String token) {
        this.tokenService.delLoginUser(token);
    }

    public void checkLogin() {
        this.getLoginUser();
    }

    public LoginUser getLoginUser() {
        String token = SecurityUtils.getToken();
        if (token == null) {
            throw new NotLoginException("\u672a\u63d0\u4f9btoken");
        }
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            throw new NotLoginException("\u65e0\u6548\u7684token");
        }
        return loginUser;
    }

    public LoginUser getLoginUser(String token) {
        return this.tokenService.getLoginUser(token);
    }

    public void verifyLoginUserExpire(LoginUser loginUser) {
        this.tokenService.verifyToken(loginUser);
    }

    public boolean hasPermi(String permission) {
        return this.hasPermi(this.getPermiList(), permission);
    }

    public void checkPermi(String permission) {
        if (!this.hasPermi(this.getPermiList(), permission)) {
            throw new NotPermissionException(permission);
        }
    }

    public void checkPermi(RequiresPermissions requiresPermissions) {
        if (requiresPermissions.logical() == Logical.AND) {
            this.checkPermiAnd(requiresPermissions.value());
        } else {
            this.checkPermiOr(requiresPermissions.value());
        }
    }

    public void checkPermiAnd(String ... permissions) {
        Set<String> permissionList = this.getPermiList();
        for (String permission : permissions) {
            if (this.hasPermi(permissionList, permission)) continue;
            throw new NotPermissionException(permission);
        }
    }

    public void checkPermiOr(String ... permissions) {
        Set<String> permissionList = this.getPermiList();
        for (String permission : permissions) {
            if (!this.hasPermi(permissionList, permission)) continue;
            return;
        }
        if (permissions.length > 0) {
            throw new NotPermissionException(permissions);
        }
    }

    public boolean hasRole(String role) {
        return this.hasRole(this.getRoleList(), role);
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(role);
        }
    }

    public void checkRole(RequiresRoles requiresRoles) {
        if (requiresRoles.logical() == Logical.AND) {
            this.checkRoleAnd(requiresRoles.value());
        } else {
            this.checkRoleOr(requiresRoles.value());
        }
    }

    public void checkRoleAnd(String ... roles) {
        Set<String> roleList = this.getRoleList();
        for (String role : roles) {
            if (this.hasRole(roleList, role)) continue;
            throw new NotRoleException(role);
        }
    }

    public void checkRoleOr(String ... roles) {
        Set<String> roleList = this.getRoleList();
        for (String role : roles) {
            if (!this.hasRole(roleList, role)) continue;
            return;
        }
        if (roles.length > 0) {
            throw new NotRoleException(roles);
        }
    }

    public void checkByAnnotation() {
        this.checkLogin();
    }

    public void checkByAnnotation(RequiresRoles at) {
        String[] roleArray = at.value();
        if (at.logical() == Logical.AND) {
            this.checkRoleAnd(roleArray);
        } else {
            this.checkRoleOr(roleArray);
        }
    }

    public void checkByAnnotation(RequiresPermissions at) {
        String[] permissionArray = at.value();
        if (at.logical() == Logical.AND) {
            this.checkPermiAnd(permissionArray);
        } else {
            this.checkPermiOr(permissionArray);
        }
    }

    public Set<String> getRoleList() {
        try {
            LoginUser loginUser = this.getLoginUser();
            return loginUser.getRoles();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public Set<String> getPermiList() {
        try {
            LoginUser loginUser = this.getLoginUser();
            return loginUser.getPermissions();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public boolean hasPermi(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.equals(x) || PatternMatchUtils.simpleMatch((String)x, (String)permission));
    }

    public boolean hasRole(Collection<String> roles, String role) {
        return roles.stream().filter(StringUtils::hasText).anyMatch(x -> SUPER_ADMIN.equals(x) || PatternMatchUtils.simpleMatch((String)x, (String)role));
    }
}

