/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.service;

import cn.hutool.crypto.SecureUtil;
import com.af.v4.system.api.RemoteUserService;
import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.utils.JwtUtils;
import com.af.v4.system.common.core.utils.ServletUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.ip.IpUtils;
import com.af.v4.system.common.core.utils.uuid.IdUtils;
import com.af.v4.system.common.plugins.core.SecureTools;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.security.config.TokenProperties;
import com.af.v4.system.common.security.utils.SecurityUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenService.class);
    protected static final long MILLIS_SECOND = 1000L;
    protected static final long MILLIS_MINUTE = 60000L;
    private static final String ACCESS_TOKEN = "login_tokens:";
    private final RedisService redisService;
    private final TokenProperties tokenProperties;
    private final RemoteUserService remoteUserService;

    public TokenService(RedisService redisService, TokenProperties tokenProperties, RemoteUserService remoteUserService) {
        this.redisService = redisService;
        this.tokenProperties = tokenProperties;
        this.remoteUserService = remoteUserService;
    }

    public Map<String, Object> createToken(LoginUser loginUser) {
        String token = IdUtils.fastUUID();
        Long userId = loginUser.getSysUser().getUserId();
        String userName = loginUser.getSysUser().getUserName();
        loginUser.setToken(token);
        loginUser.setUserid(userId);
        loginUser.setUsername(userName);
        loginUser.setIpaddr(IpUtils.getIpAddr());
        loginUser.setSessionEncryptKey(SecureUtil.sha256((String)token).substring(0, 32));
        this.refreshToken(loginUser);
        this.recordSessionAsync(loginUser);
        HashMap<String, Object> claimsMap = new HashMap<String, Object>(3);
        claimsMap.put("user_key", token);
        claimsMap.put("id", userId);
        claimsMap.put("f_username", userName);
        HashMap<String, Object> rspMap = new HashMap<String, Object>(3);
        rspMap.put("access_token", JwtUtils.createToken(claimsMap));
        rspMap.put("expires_in", this.getExpirationTime(loginUser));
        rspMap.put("session", SecureTools.RSAEncrypt((String)loginUser.getSessionEncryptKey(), (String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCEa5n7SwxwkKkRBCdd9jp7vlt75hW3Re0A++dUq3Awxg0387s9cwbhJb5B4bgwW+ymZF6wiHvjIb19iL8XCzm5d32l/nr2JZ349h0WxdISKUC7iKttrS9OmXFecO8Ki8VGUaRRJSBZvIGU5FL3yl1bh8PPXuHWg1YVOYStxhzRkwIDAQAB"));
        rspMap.put("resources", loginUser.getResources());
        return rspMap;
    }

    public LoginUser getLoginUser() {
        return this.getLoginUser(ServletUtils.getRequest());
    }

    public LoginUser getLoginUser(HttpServletRequest request) {
        String token = SecurityUtils.getToken(request);
        return this.getLoginUser(token);
    }

    public LoginUser getLoginUser(String token) {
        try {
            if (StringUtils.isNotEmpty((String)token)) {
                String userKey = JwtUtils.getUserKey((String)token);
                if (userKey == null) {
                    return null;
                }
                LoginUser user = (LoginUser)this.redisService.get(this.getTokenKey(userKey));
                return user;
            }
        }
        catch (Exception e) {
            LOGGER.error("TOKEN({})\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)token, (Object)e.getMessage());
        }
        return null;
    }

    public void setLoginUser(LoginUser loginUser) {
        if (StringUtils.isNotNull((Object)loginUser) && StringUtils.isNotEmpty((String)loginUser.getToken())) {
            this.refreshToken(loginUser);
        }
    }

    public void delLoginUser(String token) {
        if (StringUtils.isNotEmpty((String)token)) {
            String userKey = JwtUtils.getUserKey((String)token);
            if (userKey == null) {
                return;
            }
            this.redisService.delete(this.getTokenKey(userKey));
            this.redisService.delete(this.getSecureKey(userKey));
        }
    }

    public void verifyToken(LoginUser loginUser) {
        long refreshThresholdMillis;
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= (refreshThresholdMillis = this.tokenProperties.getRefreshTime() * 60000L)) {
            this.refreshToken(loginUser);
        }
    }

    public void refreshToken(LoginUser loginUser) {
        loginUser.setLoginTime(Long.valueOf(System.currentTimeMillis()));
        Long expirationMinutes = this.getExpirationTime(loginUser);
        loginUser.setExpireTime(Long.valueOf(loginUser.getLoginTime() + expirationMinutes * 60000L));
        Long expireSeconds = expirationMinutes * 60L;
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisService.set(userKey, (Object)loginUser, (Object)expireSeconds);
        LOGGER.warn("\u6839\u636euuid\u5c06loginUser\u7f13\u5b58 userKey {} \uff1a{}", (Object)userKey, (Object)expireSeconds);
        String secureKey = this.getSecureKey(loginUser.getToken());
        this.redisService.set(secureKey, (Object)loginUser.getSessionEncryptKey(), (Object)expireSeconds);
    }

    private Long getExpirationTime(LoginUser loginUser) {
        if (loginUser.isExternalUser()) {
            return this.tokenProperties.getExternalUserExpiration();
        }
        return this.tokenProperties.getExpiration();
    }

    private String getTokenKey(@NonNull String token) {
        return ACCESS_TOKEN + token;
    }

    private String getSecureKey(String token) {
        return "session_secure_key:" + token;
    }

    @Async
    protected void recordSessionAsync(LoginUser loginUser) {
        try {
            LOGGER.debug("\u5f00\u59cb\u8bb0\u5f55\u7528\u6237\u4f1a\u8bdd: token={}, user={}", (Object)loginUser.getToken(), (Object)loginUser.getUsername());
            JSONObject sessionData = new JSONObject();
            sessionData.put("token_key", (Object)loginUser.getToken());
            sessionData.put("auth_id", (Object)String.valueOf(loginUser.getUserid()));
            sessionData.put("auth_identifier", (Object)loginUser.getUsername());
            sessionData.put("auth_type", (Object)(loginUser.isExternalUser() ? "EXTERNAL_USER" : "SYSTEM_USER"));
            sessionData.put("login_ip", (Object)loginUser.getIpaddr());
            sessionData.put("status", 1);
            LocalDateTime now = LocalDateTime.now();
            sessionData.put("login_time", (Object)now.toString());
            sessionData.put("last_access_time", (Object)now.toString());
            long expireMinutes = this.getExpirationTime(loginUser);
            LocalDateTime expireTime = now.plusMinutes(expireMinutes);
            sessionData.put("expire_time", (Object)expireTime.toString());
            HttpServletRequest httpRequest = ServletUtils.getRequest();
            if (httpRequest != null) {
                String userAgent = httpRequest.getHeader("User-Agent");
                if (StringUtils.isNotEmpty((String)userAgent)) {
                    this.parseUserAgent(userAgent, sessionData);
                } else {
                    sessionData.put("browser", (Object)"Unknown");
                    sessionData.put("os", (Object)"Unknown");
                    sessionData.put("client_type", (Object)"WEB");
                }
            } else {
                sessionData.put("browser", (Object)"Unknown");
                sessionData.put("os", (Object)"Unknown");
                sessionData.put("client_type", (Object)"WEB");
            }
            sessionData.put("tenant_id", 0);
            this.remoteUserService.recordSession(sessionData.toString(), "inner");
            LOGGER.debug("\u4f1a\u8bdd\u8bb0\u5f55\u5b8c\u6210: token={}", (Object)loginUser.getToken());
        }
        catch (Exception e) {
            LOGGER.error("\u8bb0\u5f55\u4f1a\u8bdd\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38: token={}, user={}", new Object[]{loginUser.getToken(), loginUser.getUsername(), e});
        }
    }

    private void parseUserAgent(String userAgent, JSONObject sessionData) {
        try {
            String browser = "Unknown";
            String os = "Unknown";
            String clientType = "WEB";
            userAgent = userAgent.toLowerCase();
            if (userAgent.contains("chrome")) {
                browser = "Chrome";
            } else if (userAgent.contains("firefox")) {
                browser = "Firefox";
            } else if (userAgent.contains("safari") && !userAgent.contains("chrome")) {
                browser = "Safari";
            } else if (userAgent.contains("edge")) {
                browser = "Edge";
            } else if (userAgent.contains("opera")) {
                browser = "Opera";
            }
            if (userAgent.contains("windows")) {
                os = "Windows";
            } else if (userAgent.contains("mac")) {
                os = "macOS";
            } else if (userAgent.contains("linux")) {
                os = "Linux";
            } else if (userAgent.contains("android")) {
                os = "Android";
                clientType = "MOBILE";
            } else if (userAgent.contains("iphone") || userAgent.contains("ipad")) {
                os = "iOS";
                clientType = "MOBILE";
            }
            sessionData.put("browser", (Object)browser);
            sessionData.put("os", (Object)os);
            sessionData.put("client_type", (Object)clientType);
        }
        catch (Exception e) {
            LOGGER.warn("\u89e3\u6790User-Agent\u5931\u8d25: {}", (Object)userAgent, (Object)e);
            sessionData.put("browser", (Object)"Unknown");
            sessionData.put("os", (Object)"Unknown");
            sessionData.put("client_type", (Object)"WEB");
        }
    }
}

