/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.handler;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.DemoModeException;
import com.af.v4.system.common.core.exception.InnerAuthException;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.exception.auth.NotPermissionException;
import com.af.v4.system.common.core.exception.auth.NotRoleException;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.text.Convert;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.core.utils.html.EscapeUtil;
import com.af.v4.system.common.core.web.domain.AjaxResult;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final ApplicationService applicationService;

    public GlobalExceptionHandler(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @ExceptionHandler(value={NotPermissionException.class})
    public AjaxResult handleNotPermissionException(NotPermissionException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u6743\u9650\u7801\u6821\u9a8c\u5931\u8d25'{}'", (Object)requestURI, (Object)e.getMessage());
        return AjaxResult.error((int)403, (String)"\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={NotRoleException.class})
    public AjaxResult handleNotRoleException(NotRoleException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u89d2\u8272\u6743\u9650\u6821\u9a8c\u5931\u8d25'{}'", (Object)requestURI, (Object)e.getMessage());
        return AjaxResult.error((int)403, (String)"\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AjaxResult handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public AjaxResult handleServiceException(ServiceException e, HttpServletRequest request) {
        Integer code = e.getCode();
        String requestURI = request.getRequestURI();
        if (e instanceof LogicException) {
            LogicException ex = (LogicException)e;
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38.\n{}", (Object)requestURI, (Object)ex.getStack());
        } else {
            log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u670d\u52a1\u7aef\u5f02\u5e38.", (Object)requestURI, (Object)e);
        }
        String message = this.getExceptionMessage(e, code);
        return StringUtils.isNotNull((Object)code) ? AjaxResult.error((int)code, (String)message) : AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={MissingPathVariableException.class})
    public AjaxResult handleMissingPathVariableException(MissingPathVariableException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u8def\u5f84\u4e2d\u7f3a\u5c11\u5fc5\u9700\u7684\u8def\u5f84\u53d8\u91cf'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)String.format("\u8bf7\u6c42\u8def\u5f84\u4e2d\u7f3a\u5c11\u5fc5\u9700\u7684\u8def\u5f84\u53d8\u91cf[%s]", e.getVariableName()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public AjaxResult handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String value = Convert.toStr((Object)e.getValue());
        if (StringUtils.isNotEmpty((String)value)) {
            value = EscapeUtil.clean((String)value);
        }
        log.error("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)String.format("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u53c2\u6570[%s]\u8981\u6c42\u7c7b\u578b\u4e3a\uff1a'%s'\uff0c\u4f46\u8f93\u5165\u503c\u4e3a\uff1a'%s'", e.getName(), e.getRequiredType().getName(), value));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public AjaxResult handleRuntimeException(RuntimeException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u8fd0\u884c\u65f6\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38.", (Object)requestURI, (Object)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult handleBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().getFirst()).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = Objects.requireNonNull(e.getBindingResult().getFieldError()).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={InnerAuthException.class})
    public AjaxResult handleInnerAuthException(InnerAuthException e) {
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={DemoModeException.class})
    public AjaxResult handleDemoModeException(DemoModeException e) {
        return AjaxResult.error((String)"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
    }

    private String getExceptionMessage(ServiceException e, Integer code) {
        String message;
        LogicException ex;
        EnvType envType = this.applicationService.getEnvType();
        if (e instanceof LogicException) {
            ex = (LogicException)e;
            if (code == 412) {
                String message2 = ex.getStack();
                return message2;
            }
        }
        if (envType != EnvType.PROD) {
            if (code == 500 && e instanceof LogicException) {
                ex = (LogicException)e;
                message = ex.getStack();
            } else {
                message = e.getMessage();
            }
        } else {
            message = code == null || code == 500 || code == 506 ? "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef" : e.getMessage();
        }
        return message;
    }
}

