/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.security.aspect;

import com.af.v4.system.common.security.annotation.RequiresLogin;
import com.af.v4.system.common.security.annotation.RequiresPermissions;
import com.af.v4.system.common.security.annotation.RequiresRoles;
import com.af.v4.system.common.security.auth.AuthUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PreAuthorizeAspect {
    public static final String POINTCUT_SIGN = " @annotation(com.af.v4.system.common.security.annotation.RequiresLogin) || @annotation(com.af.v4.system.common.security.annotation.RequiresPermissions) || @annotation(com.af.v4.system.common.security.annotation.RequiresRoles)";

    @Pointcut(value=" @annotation(com.af.v4.system.common.security.annotation.RequiresLogin) || @annotation(com.af.v4.system.common.security.annotation.RequiresPermissions) || @annotation(com.af.v4.system.common.security.annotation.RequiresRoles)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        this.checkMethodAnnotation(signature.getMethod());
        return joinPoint.proceed();
    }

    public void checkMethodAnnotation(Method method) {
        RequiresPermissions requiresPermissions;
        RequiresRoles requiresRoles;
        RequiresLogin requiresLogin = method.getAnnotation(RequiresLogin.class);
        if (requiresLogin != null) {
            AuthUtil.checkLogin();
        }
        if ((requiresRoles = method.getAnnotation(RequiresRoles.class)) != null) {
            AuthUtil.checkRole(requiresRoles);
        }
        if ((requiresPermissions = method.getAnnotation(RequiresPermissions.class)) != null) {
            AuthUtil.checkPermi(requiresPermissions);
        }
    }
}

