/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.plugins.io.IOTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModuleMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleMapper.class);
    private static final String MODULE_FILE_NAME = "module.xml";
    private static final String EXTRA_RESOURCE_FILE_NAME = "/resource.json";
    private static final String MODE_NAME = "module";
    private static final String IMPORT_NAME = "import";
    private static final String BASE_TENANT_PATH = "/tenants/";
    private static final String BASE_TENANT_CONFIG_PATH = "/tenants.json";
    private static Map<String, Map<String, String>> map;
    private final ApplicationService applicationService;

    public ModuleMapper(ApplicationService applicationService) {
        this.applicationService = applicationService;
        map = new LinkedHashMap<String, Map<String, String>>(8);
        this.loadModuleBootstrap(MODULE_FILE_NAME, true);
    }

    public Map<String, Map<String, String>> getMap() {
        return map;
    }

    private void parseTenantModule() {
        block13: {
            if (this.applicationService.getEnvType() != EnvType.LOCAL) {
                try {
                    JsonTools.readJsonArrayFile((String)BASE_TENANT_CONFIG_PATH).forEach(moduleObj -> {
                        String moduleName = moduleObj.toString();
                        this.addTenantModule(moduleName);
                    });
                }
                catch (Exception e) {
                    LOGGER.error("\u901a\u8fc7\u8bfb\u53d6JSON\u914d\u7f6e\u52a0\u8f7d\u79df\u6237\u6a21\u5757\u5931\u8d25", (Throwable)e);
                }
            } else {
                try {
                    URL url = ModuleMapper.class.getResource(BASE_TENANT_PATH);
                    if (url == null) break block13;
                    Path dir = Paths.get(url.toURI());
                    try (Stream<Path> stream = Files.list(dir);){
                        stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).forEach(this::addTenantModule);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("\u901a\u8fc7\u8bfb\u53d6\u76ee\u5f55\u52a0\u8f7d\u79df\u6237\u6a21\u5757\u5931\u8d25", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    LOGGER.error("URI\u8bed\u6cd5\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }

    private void addTenantModule(String moduleName) {
        HashMap<String, String> module = new HashMap<String, String>(3);
        module.put("path", "tenants");
        try {
            JSONObject resourceJson = JsonTools.readJsonFile((String)(BASE_TENANT_PATH + moduleName + EXTRA_RESOURCE_FILE_NAME));
            JSONArray mappingVisualModules = resourceJson.optJSONArray("mappingVisualModules");
            if (mappingVisualModules != null) {
                String mappingVisualModulesStr = mappingVisualModules.toString();
                module.put("mappingVisualModules", mappingVisualModulesStr);
                LOGGER.info(">>> \u6a21\u5757\uff1a[{}]\u52a0\u8f7d\u865a\u62df\u6620\u5c04\u6a21\u5757{}", (Object)moduleName, (Object)mappingVisualModulesStr);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        map.put(moduleName, module);
        LOGGER.info(">>> \u6a21\u5757\uff1a[{}]\u52a0\u8f7d\u5b8c\u6210", (Object)moduleName);
    }

    private void parseImportModule(Element root) {
        List ite = root.elements(IMPORT_NAME);
        if (!ite.isEmpty()) {
            for (Element elm : ite) {
                String name = elm.attribute("name").getValue();
                LOGGER.info("====\u4ece\u6a21\u5757\u96c6[{}]\u5bfc\u5165\u6a21\u5757====", (Object)name);
                this.loadModuleBootstrap(name + "/module.xml", false);
            }
        }
    }

    private void parseProjectModule(Element root) {
        Iterator it = root.elementIterator(MODE_NAME);
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            String path = elm.attributeValue("path");
            HashMap<String, String> module = new HashMap<String, String>(3);
            module.put("upload", upload);
            module.put("path", path);
            map.put(name, module);
            LOGGER.info(">>> \u6a21\u5757\uff1a[{}]\u52a0\u8f7d\u5b8c\u6210", (Object)name);
        }
    }

    private void loadModuleBootstrap(String path, boolean isRoot) {
        IOTools.getStream((String)path, stream -> {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(stream);
                Element root = document.getRootElement();
                this.parseImportModule(root);
                if (isRoot) {
                    LOGGER.info("====\u4ece\u79df\u6237\u76ee\u5f55\u5bfc\u5165\u6a21\u5757====");
                    this.parseTenantModule();
                    LOGGER.info("====\u4ece\u672c\u5730\u76ee\u5f55\u5bfc\u5165\u6a21\u5757====");
                }
                this.parseProjectModule(root);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }, errorPath -> {
            throw new ServiceException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6[module.xml]\u672a\u627e\u5230\uff0c\u76f8\u5173\u8def\u5f84\uff1a" + errorPath, Integer.valueOf(506));
        });
    }
}

