/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.resource.mapper;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import com.af.v4.system.common.resource.mapper.ModuleMapper;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class ReportMapper
extends AbstractResourceMapper<ReportResource> {
    private static final Boolean DEFAULT_MOBILE_STATE = false;

    protected ReportMapper(ModuleMapper moduleMapper, ApplicationService applicationService, ILiuLiConfigServiceProxy liuLiConfigServiceProxy) {
        super(moduleMapper, applicationService, liuLiConfigServiceProxy);
    }

    @Override
    public ResourceType getResType() {
        return ResourceType.REPORT;
    }

    @Override
    public String getFileName() {
        return "report.xml";
    }

    @Override
    public String getFolderName() {
        return "reports";
    }

    @Override
    protected ReportResource buildResourceImpl(String moduleName, String key, String path, JSONObject liuliValue, Map<String, Object> attrMap) {
        Object dataSource = attrMap.get("dataSource");
        Object mobile = attrMap.get("mobile");
        return new ReportResource(this, moduleName, key, path, liuliValue, dataSource == null ? null : dataSource.toString(), mobile == null ? DEFAULT_MOBILE_STATE : Boolean.parseBoolean(mobile.toString()));
    }

    @Override
    public boolean isSupportCompile() {
        return false;
    }

    public static class ReportResource
    extends AbstractResourceMapper.CommonResource
    implements AbstractResourceMapper.MobileResourceSupport,
    AbstractResourceMapper.DataSourceResourceSupport {
        private final String dataSource;
        private final boolean mobile;

        public ReportResource(AbstractResourceMapper<?> mapper, String moduleName, String key, String path, JSONObject liuliValue, String dataSource, Boolean mobile) {
            super(mapper, moduleName, key, path, liuliValue);
            this.dataSource = dataSource;
            this.mobile = mobile;
        }

        @Override
        public String getDataSource() {
            return this.dataSource;
        }

        @Override
        public boolean isMobile() {
            return this.mobile;
        }
    }
}

