/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis.entity;

import java.io.Serializable;
import java.util.UUID;
import org.json.JSONObject;

public class FastCacheQueueEntity
implements Serializable {
    private final String id;
    private final int currRetryTimes;
    private final int maxRetryTimes;
    private final long timestamp;
    private final JSONObject data;

    private FastCacheQueueEntity(Builder builder) {
        this.id = builder.id != null ? builder.id : UUID.randomUUID().toString();
        this.timestamp = builder.timestamp > 0L ? builder.timestamp : System.currentTimeMillis();
        this.currRetryTimes = builder.currRetryTimes;
        this.maxRetryTimes = builder.maxRetryTimes;
        this.data = builder.data;
    }

    public String getId() {
        return this.id;
    }

    public int getCurrRetryTimes() {
        return this.currRetryTimes;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public JSONObject getData() {
        return this.data;
    }

    public String toString() {
        return "FastCacheQueueEntity --> {id='" + this.id + "', currRetryTimes=" + this.currRetryTimes + ", maxRetryTimes=" + this.maxRetryTimes + ", timestamp=" + this.timestamp + ", data=" + String.valueOf(this.data) + "}";
    }

    public static class Builder {
        private String id;
        private int currRetryTimes = 0;
        private int maxRetryTimes = 3;
        private long timestamp;
        private JSONObject data;

        public Builder data(JSONObject data) {
            this.data = data;
            return this;
        }

        public Builder currRetryTimes(int currRetryTimes) {
            this.currRetryTimes = currRetryTimes;
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public FastCacheQueueEntity build() {
            return new FastCacheQueueEntity(this);
        }
    }
}

