/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.redis;

import com.af.v4.system.common.redis.entity.FastCacheQueueEntity;
import com.af.v4.system.common.redis.exception.LockInterruptedException;
import com.af.v4.system.common.redis.exception.LockTimeoutException;
import com.af.v4.system.common.redis.utils.DistributedLockUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.json.JSONArray;
import org.json.JSONObject;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RMap;
import org.redisson.api.RScript;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.options.KeysScanOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedisService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisService.class);
    private final RedissonClient redissonClient;
    private final DistributedLockUtil distributedLockUtil;

    public RedisService(RedissonClient REDISSON_CLIENT, DistributedLockUtil distributedLockUtil) {
        this.redissonClient = REDISSON_CLIENT;
        this.distributedLockUtil = distributedLockUtil;
    }

    public <T> void set(String key, T value) {
        this.set(key, value, -1);
    }

    public <T> void set(String key, T value, Object timeoutSec) {
        Object realValue = (value instanceof JSONObject || value instanceof JSONArray) && value.toString() != null ? value.toString() : value;
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RBucket rBucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        if (timeoutSecValue > 0L) {
            rBucket.set(realValue, Duration.ofSeconds(timeoutSecValue));
        } else {
            rBucket.set(realValue);
        }
    }

    public <T> void setHash(String hashKey, Map<String, T> value) {
        this.setHash(hashKey, value, -1);
    }

    public <T> void setHash(String hashKey, Map<String, T> value, Object timeoutSec) {
        long timeoutSecValue = Long.parseLong(timeoutSec.toString());
        RMap rMap = this.redissonClient.getMap(hashKey);
        rMap.putAll(value);
        if (timeoutSecValue > 0L) {
            rMap.expire(Duration.ofSeconds(timeoutSecValue));
        }
    }

    public JSONObject getHash(String hashKey) {
        return new JSONObject((Map)this.redissonClient.getMap(hashKey));
    }

    public <T> T getHash(String hashKey, String key) {
        RMap map = this.redissonClient.getMap(hashKey);
        return (T)map.get((Object)key);
    }

    public <T> void setHashKey(String hashKey, String key, T value) {
        RMap map = this.redissonClient.getMap(hashKey);
        map.put((Object)key, value);
    }

    public void deleteHashKey(String hashKey, String key) {
        this.redissonClient.getMap(hashKey).remove((Object)key);
    }

    public Boolean hasHashKey(String hashKey, String key) {
        return this.redissonClient.getMap(hashKey).containsKey((Object)key);
    }

    public <T> T syncLock(String key, Integer leaseTime, Supplier<T> supplier) throws LockInterruptedException {
        return this.distributedLockUtil.syncLock(key, leaseTime, supplier);
    }

    public <T> T syncLock(String key, Supplier<T> supplier) throws LockInterruptedException {
        return this.distributedLockUtil.syncLock(key, supplier);
    }

    public <T> T lock(String key, Integer waitTime, Integer leaseTime, Supplier<T> supplier) throws LockTimeoutException, LockInterruptedException {
        return this.distributedLockUtil.lock(key, waitTime, leaseTime, supplier);
    }

    public <T> T lock(String key, Supplier<T> supplier) throws LockTimeoutException, LockInterruptedException {
        return this.distributedLockUtil.lock(key, supplier);
    }

    public void lock(String key, Integer waitTime, Integer leaseTime, Runnable runnable) throws LockTimeoutException, LockInterruptedException {
        this.lock(key, waitTime, leaseTime, () -> {
            runnable.run();
            return null;
        });
    }

    public void lock(String key, Runnable runnable) throws LockTimeoutException, LockInterruptedException {
        this.lock(key, () -> {
            runnable.run();
            return null;
        });
    }

    public <T> T get(String key) {
        String resultStr;
        RBucket bucket = this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE);
        Object result = bucket.get();
        Object realValue = result instanceof String ? ((resultStr = (String)result).startsWith("{") && resultStr.endsWith("}") ? new JSONObject(resultStr) : (resultStr.startsWith("[") && resultStr.endsWith("]") ? new JSONArray(resultStr) : result)) : result;
        return (T)realValue;
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        T result = this.get(key);
        return result == null ? defaultValue : result;
    }

    public boolean hasKey(String key) {
        return this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).isExists();
    }

    public void delete(String key) {
        this.redissonClient.getBucket(key, (Codec)JsonJacksonCodec.INSTANCE).delete();
    }

    public <T> void deleteList(Iterator<T> keys) {
        RBatch batch = this.redissonClient.createBatch();
        while (keys.hasNext()) {
            batch.getBucket(keys.next().toString()).deleteAsync();
        }
        batch.execute();
    }

    public void deleteList(JSONArray keys) {
        this.deleteList(keys.iterator());
    }

    public Iterator<String> getKeys(String pattern) {
        RKeys keys = this.redissonClient.getKeys();
        return keys.getKeys(KeysScanOptions.defaults().pattern(pattern)).iterator();
    }

    public void deleteKeysByPatternSafely(String pattern) {
        RScript script = this.redissonClient.getScript((Codec)StringCodec.INSTANCE);
        String luaScript = "local cursor = '0' \nlocal count = 0 \nrepeat \n    local result = redis.call('SCAN', cursor, 'MATCH', ARGV[1], 'COUNT', ARGV[2]) \n    cursor = result[1] \n    local keys = result[2] \n    if #keys > 0 then \n        redis.call('UNLINK', unpack(keys)) \n        count = count + #keys \n    end \nuntil cursor == '0' \nreturn count";
        script.eval(RScript.Mode.READ_WRITE, luaScript, RScript.ReturnType.INTEGER, Collections.emptyList(), new Object[]{pattern, String.valueOf(1000)});
    }

    public RTopic getTopic(String topicName) {
        return this.redissonClient.getTopic(topicName, (Codec)JsonJacksonCodec.INSTANCE);
    }

    public RBlockingQueue<String> getBlockingQueue(String queueName) {
        return this.redissonClient.getBlockingQueue(queueName);
    }

    public <T> void pushToQueue(String queueName, T data) {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue(queueName);
        try {
            queue.put(data);
            LOGGER.info(">>> \u6570\u636e\u5df2\u63a8\u9001\u81f3\u961f\u5217\uff1a{}, \u5185\u5bb9\uff1a{}", (Object)queueName, data);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("\u63a8\u9001\u6570\u636e\u4e2d\u65ad\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void pushToQueue(String queueName, JSONObject data) {
        FastCacheQueueEntity fastCacheQueue = new FastCacheQueueEntity.Builder().maxRetryTimes(data.optInt("maxRetryTimes", 3)).data(data.optJSONObject("data")).build();
        this.pushToQueue(queueName, fastCacheQueue);
    }

    public <T> T blockingPopFromQueue(String queueName) {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue(queueName);
        try {
            return (T)queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error(">>> \u83b7\u53d6\u961f\u5217\u6570\u636e\u4e2d\u65ad\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public long incr(String key, long delta, long initialValue, long expireSeconds) {
        RAtomicLong atomic = this.redissonClient.getAtomicLong(key);
        if (!atomic.isExists()) {
            atomic.set(initialValue);
            if (expireSeconds > 0L) {
                atomic.expire(Duration.ofSeconds(expireSeconds));
            }
        }
        return atomic.addAndGet(delta);
    }
}

