package com.af.v4.system.common.redis.exception;

/**
 * 自定义异常：表示锁操作过程中线程被中断。
 * 通常用于响应中断信号时保持线程中断状态并抛出业务异常。
 */
public class LockInterruptedException extends RuntimeException {

    /**
     * 构造函数，包含异常信息
     *
     * @param message 异常描述
     */
    public LockInterruptedException(String message) {
        super(message);
    }

    /**
     * 构造函数，包含异常信息和原始异常
     *
     * @param message 异常描述
     * @param cause   原始异常
     */
    public LockInterruptedException(String message, Throwable cause) {
        super(message, cause);
    }
}
